library(MLGL)
library(fastcluster)

for(n in N)
{
  for(p in P)
  {
    for(rho in RHO)
    {   
      for(l in L)
      {
        for(k in K)
        {
          
          cat("n=",n," p=",p," rho=",rho," L=",l," K=",k,"\n")
          nfalsehc = ntruehc <- list()
          for(j in 1:(length(alpha)+1))
            nfalsehc[[j]] = ntruehc[[j]] = matrix(NA, nrow = nbSample, ncol = 100)
          
          for(sample in 1:nbSample)
          {
            
            load(paste0("data/datan",n,"p",p,"rho",rho,"l",l,"sample",sample,".RData"))
            load(paste0("data/repn",n,"p",p,"rho",rho,"l",l,"K",k,"sample",sample,".RData"))
            ind1 <- 1:(nrow(X)/2)
            
            ## hierarchical clustering
            cah <- MLGL:::bootstrapHclust(X, frac = 1, B = 50, method = metHC, nCore = 4)
            
            ## MLGL
            res = MLGL(X[-ind1,], y[-ind1], cah)
            
            
            ## perform hierarchical testing for different alpha values
            sel = test  <- list()
            for(j in seq_along(alpha))
              sel[[j]] = list(group = list(), var = list())
            
            for(i in 1:100)
            {
              if(length(res$group[[i]]) != 0)
              {
                test[[i]] = hierarchicalFWER(X, y, res$group[[i]], res$var[[i]])
                for(j in seq_along(alpha))
                {
                  out <- selFWER(test[[i]], alpha = alpha[j])
                  
                  sel[[j]]$group[[i]] = res$group[[i]][res$group[[i]] %in%(out$groupId[out$toSel])]
                  sel[[j]]$var[[i]] = res$var[[i]][res$group[[i]] %in%(out$groupId[out$toSel])]
                }
                
              }
              
            }
            
            ## compute true and false positive
            for(j in 1:(length(alpha)+1))
            {
              if(j != 1)
              {
                non0hcgg <- sel[[j-1]]$var
                non0hcggGroup <- sel[[j-1]]$group
              }else{
                non0hcgg <- res$var
                non0hcggGroup <- res$group
              }
              
              indtghc = lapply(1:100,FUN=function(i)
              {
                indVraiVar = which(non0hcgg[[i]]%in%trueind)
                var = non0hcgg[[i]][indVraiVar]
                gr = non0hcggGroup[[i]][indVraiVar]
                # groupe contenant au moins 1 vraie variable
                tg = unique(gr)
                # numéro de groupe associé aux vraies variables présentes
                g = non0hcggGroup[[i]][indVraiVar]
                # on enlève les groupes contenant plusieurs vraie var
                tg = setdiff(tg,unique(g[duplicated(g)]))
                ind = gr%in%tg
                rbind(gr[ind], var[ind])
              })
              
              indfghc = lapply(1:100, FUN=function(i)
              {
                allgr = unique(non0hcggGroup[[i]])
                
                setdiff(allgr, indtghc[[i]][1,])
              })
              
              nfalsehc[[j]][sample,] = sapply(indfghc, length)
              ntruehc[[j]][sample,] = sapply(indtghc, function(x){length(unique(x[2,]))})
            }
            
            
          }
          
          ntrue <- sapply(ntruehc, function(x){colMeans(x)})
          nfalse <- sapply(nfalsehc, function(x){colMeans(x)})
          
          pdf(paste0("plot/tfalphan",n,"p",p,"rho",rho,"l",l,"K",k,".pdf"))
          matplot(res$lambda/max(res$lambda), cbind(ntrue, nfalse), type = "l", col = c(1:2,4:10)[rep(1:(length(alpha)+1), 2)], lty = rep(1:2, each = length(alpha)+1), 
                  xlab = expression(lambda/lambda[max]), ylab = "Number of groups", ylim = c(0, 10))
          legend("topright", c("TP MLGL", "FP MLGL", unlist(lapply(alpha, function(x) paste0(c("TP MLGL+HMT ", "FP MLGL+HMT "), x)))), 
                 col = c(1:2,4:10)[rep(1:(length(alpha)+1), each = 2)], lty = rep(1:2, length(alpha)+1), cex = 0.6)
          dev.off()
        }# fin for K
      }#fin for l
    }#fin for RHO
  }#fin for P
}# fin for n
