library(gglasso)
library(MLGL)
library(foreach)
library(doParallel)
# n <- 200
# nbSample <- 100
# P <- 500
# K <- c(5, 10)
# L <- c(5, 10)
# RHO <- c(0.9,0.7,0.5)
cat("------------------------- 5f-cv -------------------------\n")
cl <- parallel::makeCluster(6)
doParallel::registerDoParallel(cl)
for(n in N)
{
  for(p in P)
  {
    for(k in K)
    {
      for(l in L)
      {
        cat(paste0("cadre=",cadre," n=",n," p=",p," k=",k," l=",l,"\n"))
        for(rho in RHO)
          #a=foreach(rho = RHO, .packages = "MLGL")%dopar%
        {
          
          indlambdaMin = indLambda1se <- rep(NA, 100)
          temps = rep(0, nbSample)
          
          for(sample in 1:nbSample)
          {
            set.seed(k * 1e7 + l * 1e5 + sample * 10 + rho * 10)
            load(paste0("Cadre",cadre,"/data/datan",n,"p",p,"rho",rho,"l",l,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/res/mlgl/mlgln",n,"p",p,"rho",rho,"l",l,"K",k,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/rep/repn",n,"p",p,"rho",rho,"l",l,"K",k,"sample",sample,".RData"))
            
            
            ##################################
            t1=proc.time()        
            rescv=cv.MLGL (X, y, nfolds = 5, lambda =res$lambda, hc = res$hc)
            t2=proc.time()
            
            temps=(t2-t1)[3]     
            print(temps)
            
            indlambdaMin[sample] = which(rescv$lambda == rescv$lambda.min)
            indLambda1se[sample] = which(rescv$lambda == rescv$lambda.1se)
          }#fin for sample
          save(indlambdaMin, indLambda1se, file = paste0("Cadre",cadre,"/res/5fcv/rescvn",n,"p",p,"rho",rho,"l",l,"K",k,"sample",sample,".RData"))
          

        }#fin for rho
      }#fin for l
      
    }#fin for K
  }#fin for p
}
parallel::stopCluster(cl)
