cat("-------- Calcul vrais/faux positifs lambda optimal --------\n")

for(n in N)
{
  for(p in P)
  {
    for(rho in RHO)
    {   
      for(l in L)
      {
        for(k in K)
        {
          
          cat("n=",n," p=",p," rho=",rho," L=",l," K=",k,"\n")
          
          suffix <- switch(cadre,
                           "1" = paste0("n",n,"p",p,"rho",rho,"l",l),
                           "2" = paste0("n",n,"p",p,"rho",rho,"l",l),
                           "3" = paste0("n",n,"p",p,"rho",rho,"l",l,"pi",round(pi,2)),
                           "4" = paste0("n",n,"p",p,"rho",rho,"rho",rho,"l",l))
          
          nTrue = nFalse <- matrix(NA, nrow = nbSample, ncol = 5)
          colnames(nTrue) = colnames(nTrue) <- c("MLGL", "HCAR", "CRL", "CGL", "SGL")
          
          # MLGL
          load(paste0("Cadre",cadre,"/res/mlgl/mlgltf",suffix,"K",k,".RData"))
          nTrue[,1] = ntrueLam
          nFalse[,1] = nfalseLam
          
          # HCAR
          load(paste0("Cadre",cadre,"/res/avg/avgtf",suffix,"K",k,".RData"))
          nTrue[,2] = ntrueLam
          nFalse[,2] = nfalseLam
          
          # CRL
          load(paste0("Cadre",cadre,"/res/crl/crltf",suffix,"K",k,".RData"))
          nTrue[,3] = ntrueLam
          nFalse[,3] = nfalseLam
          
          # CGL
          load(paste0("Cadre",cadre,"/res/cgl/cgltf",suffix,"K",k,".RData"))
          nTrue[,4] = ntrueLam
          nFalse[,4] = nfalseLam
          
          # SGL
          load(paste0("Cadre",cadre,"/res/sgl/sgltf",suffix,"K",k,".RData"))
          nTrue[,5] = ntrueLam
          nFalse[,5] = nfalseLam
          
          pdf(paste0("Cadre",cadre,"/res/comp/comptflam",suffix,"K",k,".pdf"), width = 10, height = 7)
          boxplot(nTrue[,1], nFalse[,1], nTrue[,2], nFalse[,2], nTrue[,3], nFalse[,3], nTrue[,4], nFalse[,4], nTrue[,5], nFalse[,5],
                  names = c("T MLGL", "F MLGL", "T HCAR", "F HCAR", "T CRL", "F CRL", "T CGL", "F CGL", "T SGL", "F SGL"),
                  main = "True and false groups selected by the different methods")
          dev.off()
          tfOut <- rbind(colMeans(nTrue), colMeans(nFalse))
          rownames(tfOut) = c("True positive", "False positive")
          
          print(tfOut)
        }#fin for K
      }#fin for l
    }#fin for RHO
  }#fin for P
}# fin for n
