library(fastcluster)


for(n in N)
{
  ind1 <- 1:floor(n/2)
  
  for(p in P)
  {
    for(rho in RHO)
    {   
      for(l in L)
      {
        cat("n=",n," p=",p," rho=",rho," L=",l,"\n")
        
        
        suffix <- switch(cadre,
                         "1" = paste0("n",n,"p",p,"rho",rho,"l",l),
                         "2" = paste0("n",n,"p",p,"rho",rho,"l",l),
                         "3" = paste0("n",n,"p",p,"rho",rho,"l",l,"pi",round(pi,2)),
                         "4" = paste0("n",n,"p",p,"rho",rho,"rho",rho,"l",l))
        
        for(sample in 1:nbSample)
        {
          set.seed(k * 1e7 + l * 1e5 + sample * 10 + rho * 10)
          if(sample%%10==0)
            cat("sample ",sample,"\n")
          
          
          load(paste0("Cadre",cadre,"/data/data",suffix,"sample",sample,".RData"))
          
          
          t1 <- proc.time()
          hc <- MLGL:::bootstrapHclust(X, frac = 1, B = 50, method = "ward.D2", nCore = 6)
          t2 <- proc.time()
          
          temps <- t2[3]-t1[3]
          
          save(hc, temps, file = paste0("Cadre",cadre,"/cah/cah",suffix,"sample",sample,".RData"))
        }#fin for sample
      }#fin for sizegr
    }#fin for RHO
  }#fin for P
}# fin for n
