# README

*run.R* file performs the following analysis:

## compGlasso

Compare MLGL solution path with group-lasso solution path (figure 8 & 9).

- Solution path plots are files with a the following names: `compGlasso/plot/ENtfn[*]p[*]rho[*]K[*]sizegr[*].png`
- The number of groups of the partition selected with the high jump rule is saved in files : `compGlasso/plot/ENtaillepartn[*]p[*]rho[*]K[*]sizegr[*].png`

## alpha

Testing procedure with different values of alpha parameters (figure 12).

Plots are generated in `alpha/plot`.

Figure 12 a)
alpha/plot/tfalphan100p500rho0.7l10K5.pdf
Figure 12 b)
alpha/plot/tfalphan100p500rho0.9l10K5.pdf
Figure 12 c)
alpha/plot/tfalphan100p500rho0.7l10K10.pdf
Figure 12 d)
alpha/plot/tfalphan100p500rho0.9l10K10.pdf

## methodComparison

- Compare MLGL solution path (true and false positives) with solution path of other methods combining clustering and regression (Figure 10)

*methodComparison/runall.R* file performs this analysis. Output graphs are available in `Cadre1/res/comp/`

`comptfn100p100rho0.5l5K5` represents the solution path of the different methods for n = 100 p = 100 rho = 0.5 l = 5 K = 5
`comptflamn100p100rho0.5l5K5` represents the selected groups of the different methods for n = 100 p = 100 rho = 0.5 l = 5 K = 5

- Comparison of HMT procedure with other regularization parameter selection procedure (table 1 & 2)

*methodComparison/runallCompSel.R* file performs the analysis (some parallelized code inside). Outputs are saved in `Cadre1/res/compSel/`

Table 1:
/methodComparison/Cadre1/res/HMT/*.txt

Table 2:
proposed method cells are the ones from table 1
other method cells: /methodComparison/Cadre1/res/compSel/*.txt ("MLGL+lambda_kappa", "MLGL+lambda_5fcv", "MLGL stability")

The execution time of this part is very long (> 1 day).


