cat("-------- MLGL --------\n")


library(MLGL)

# Paramètre test hiérarchique
test <- partialFtest
hierTestFunction <- hierarchicalFWER
selFunction <- selFWER
alpha <- 0.05

for(n in N)
{

  ind1 <- 1:(floor(n*factorSplit)+1)
  ind2 <- (floor(n*factorSplit)+1):n
  
  for(p in P)
  {
    for(rho in RHO)
    {   
      for(l in L)
      {
        for(k in K)
        {
          
          cat("n=",n," p=",p," rho=",rho," L=",l," K=",k,"\n")
          
          suffix <- switch(cadre,
                           "1" = paste0("n",n,"p",p,"rho",rho,"l",l),
                           "2" = paste0("n",n,"p",p,"rho",rho,"l",l),
                           "3" = paste0("n",n,"p",p,"rho",rho,"l",l,"pi",round(pi,2)),
                           "4" = paste0("n",n,"p",p,"rho",rho,"rho",rho,"l",l))
          for(sample in 1:nbSample)
          {
            set.seed(k * 1e7 + l * 1e5 + sample * 10 + rho * 10)
            load(paste0("Cadre",cadre,"/data/data",suffix,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/rep/rep",suffix,"K",k,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/cah/cah",suffix,"sample",sample,".RData"))
            
            if(sample%%10==0)
              cat("sample ",sample,"\n")
            
            ###### glasso avec matrice de var-covar de base
            res <- MLGL(X[ind2,], y[ind2], hc = hc)
            
            ###### post traitement
            t1 = proc.time()
            REJECT <- list()
            nbReject <- rep(0, length(res$lambda))
            
            prevSelGroup = selGroup <- c()
            for(i in 1:length(res$lambda))
            {
              if(length(res$group[[i]])>0)
              {
                selGroup = unique(res$group[[i]])
                
                #if the selected groups have not changed compared with the last iteration, we copy the result
                if(setequal(prevSelGroup, selGroup))
                {
                  REJECT[[i]] = REJECT[[i-1]]
                  nbReject[i] = nbReject[i-1]
                }
                else
                {
                  # hierarchical testing and selection
                  resTest <- hierTestFunction(X[ind1,], y[ind1], res$group[[i]], res$var[[i]], test)
                  resSel <- selFunction(resTest, alpha)
                  
                  # Id of rejected groups
                  REJECT[[i]] = resSel$groupId[resSel$toSel]
                  
                  # number of rejects for the lambda value
                  nbReject[i] = length(REJECT[[i]])
                }
              }
              prevSelGroup = selGroup
            }# end for lambda
            
            # indice of optimal lambda : the one with the gretest number of reject
            indLambdaOpt <- which.max(nbReject)
            t2 = proc.time()
            
            tempsPost = t2[3]-t1[3]
            
            
            
            save(res, trueind, indLambdaOpt, REJECT, tempsPost,
                 file = paste0("Cadre",cadre,"/res/mlgl/mlgl",suffix,"K",k,"sample",sample,".RData"))
            
          }#fin for sample
          
        }#fin for K
      }#fin for l
    }#fin for RHO
  }#fin for P
}# fin for n
