cat("-------- Group Lasso --------\n")

library(gglasso)

for(n in N)
{

  ind1 <- 1:(floor(n*factorSplit)+1)
  ind2 <- (floor(n*factorSplit)+1):n

 
  for(p in P)
  {
    for(rho in RHO)
    {   
      for(l in L)
      {
        for(k in K)
        {
          
          cat("n=",n," p=",p," rho=",rho," L=",l," K=",k,"\n")
          
          suffix <- switch(cadre,
                           "1" = paste0("n",n,"p",p,"rho",rho,"l",l),
                           "2" = paste0("n",n,"p",p,"rho",rho,"l",l),
                           "3" = paste0("n",n,"p",p,"rho",rho,"l",l,"pi",round(pi,2)),
                           "4" = paste0("n",n,"p",p,"rho",rho,"rho",rho,"l",l))
          for(sample in 1:nbSample)
          {
            set.seed(k * 1e7 + l * 1e5 + sample * 10 + rho * 10)
            load(paste0("Cadre",cadre,"/data/data",suffix,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/rep/rep",suffix,"K",k,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/cah/cah",suffix,"sample",sample,".RData"))
            
            if(sample%%10==0)
              cat("sample ",sample,"\n")
            
            ###### glasso avec matrice de var-covar de base
          nbGroup <- p - which.max(diff(hc$height))
          group <- cutree(hc, nbGroup)
          groupord <- order(group)
          grouprevord <- order(groupord)
          group2 <- group[groupord]
          
          res <- cv.gglasso(X[ind1, groupord], y[ind1], group = group2, nfolds = 5)
          res$gglasso.fit$beta = res$gglasso.fit$beta[grouprevord,]
          res$gglasso.fit$group = res$gglasso.fit$group[grouprevord]

            
            save(res, trueind, file = paste0("Cadre",cadre,"/res/gl/gl",suffix,"K",k,"sample",sample,".RData"))
            
          }#fin for sample
          
        }#fin for K
      }#fin for l
    }#fin for RHO
  }#fin for P
}# fin for n
