setwd("methodComparison")

# Parameters --------------------------------------------------------------
set.seed(42)
t1 <- proc.time()
# Number of repetitions
nbSample <- 100

# simulation's framework: 1, 2 or 3
# 1 : groups of the same size
# 2 : groups of different size
# 3 : groups and isolated variables
cadre <- 1

### Common parameters
# Number of individuals # one half is used for the penalized regression, the other is used for the testing procedure
N <- 100 # c(100, 200)
# Number of variables
P <- 500 #c(100, 200)
# group size # L must divide P
L <- c(5, 10)
# within group correlation
RHO <- c(0.5, 0.7, 0.9)

### Cadre 3 : The data contains groups and single variables
# Proportion of single variables
pi <- 0.5 # one value


### Response
# Number of true variables
K <- c(5, 10)
# Signal to noise ratio
SNR <- 2 # one value

# method for hclust
metHC <- "ward.D2"

#
factorSplit <- 1/2

# Clean previous data and results -----------------------------------------

source("run/dossier.R")

# Simulate data -----------------------------------------------------------

# data
source(paste0("run/simuCadre", cadre, ".R"))

# AHC
source(paste0("run/runCAH.R"))

# Response
source(paste0("run/rep.R"))

# data (resp AHC, response) are saved in the Cadre1/data (resp. Cadre1/cah, Cadre1/rep) folder

# Methods ----------------------------------------------------------------
# Multi-Layer Group-Lasso
source("run/runMLGL.R")

# Supervised Group-Lasso
source("run/runsgl.R")

# Cluster Group-Lasso
source("run/runcgl.R")

# Cluster Representative Lasso
source("run/runcrl.R")

# HCAR
source("run/runavg.R")

# Comparison -------------------------------------------------------------

# Compute True positives and false positives
source("run/runtfmlgl.R")
source("run/runtfsgl.R")
source("run/runtfcgl.R")
source("run/runtfcrl.R")
source("run/runtfavg.R")


# plot the solution path
source("run/comptf.R")

# Compare selected groups
source("run/comptflambda.R")

t2 <- proc.time()

print(t2-t1)
setwd("..")

# output graphs are available in Cadre1/res/comp/
# comptfn100p100rho0.5l5K5 represents the solution path of the different methods for n = 100 p = 100 rho = 0.5 l = 5 K = 5
# comptflamn100p100rho0.5l5K5 represents the selected groups of the different methods for n = 100 p = 100 rho = 0.5 l = 5 K = 5
