# Run using: RScript datatable_bench.r

library("data.table")
library("microbenchmark")

dt <- fread("df.csv")
bench_agg <- microbenchmark(dt[, .(sum(x), .N), grp], times = 100)
cat("data.table aggregation time:", min(bench_agg$time)/10^9, "\n")

dt1 <- fread("df1.csv")
dt2 <- fread("df2.csv")
bench_innerjoin <- microbenchmark(dt1[dt2, nomatch = NULL, on = "x"], times = 100)
cat("data.table innerjoin time:", min(bench_innerjoin$time)/10^9, "\n")
bench_leftjoin <- microbenchmark(dt2[dt1, on = "x"], times = 100)
cat("data.table leftjoin time:", min(bench_leftjoin$time)/10^9, "\n")
bench_rightjoin <- microbenchmark(dt1[dt2, on = "x"], times = 100)
cat("data.table rightjoin time:", min(bench_rightjoin$time)/10^9, "\n")
bench_outerjoin <- microbenchmark(merge(dt1, dt2, by = "x", all = TRUE), times = 100)
cat("data.table outerjoin time:", min(bench_outerjoin$time)/10^9, "\n")
