# Run using:
# python polars_bench.r

import time
import polars as pl

df_polars = pl.read_csv('df.csv')

def test_agg_polars(df):
    begin = time.time()
    df.groupby("grp").agg([pl.sum('x'), pl.count('x').alias('nrow')])
    end = time.time()
    return end-begin

print('Polars aggregation time:',
      min([test_agg_polars(df_polars) for i in range(100)]))

df1_polars = pl.read_csv('df1.csv')
df2_polars = pl.read_csv('df2.csv')

def test_join_polars(df1, df2):
    begin = time.time()
    df1.join(df2, on="x", how="inner")
    end = time.time()
    jinner = end-begin
    begin = time.time()
    df1.join(df2, on="x", how="left")
    end = time.time()
    jleft = end-begin
    # right join is not supported in Polars
    begin = time.time()
    df1.join(df2, on="x", how="outer")
    end = time.time()
    jouter = end-begin
    return (jinner, jleft, jouter)

res_join_pl = [test_join_polars(df1_polars, df2_polars) for i in range(100)]
print('Polars innerjoin time:',
      min([v[0] for v in res_join_pl]))
print('Polars leftjoin time:',
      min([v[1] for v in res_join_pl]))
print('Polars outerjoin time:',
      min([v[2] for v in res_join_pl]))
