# Start Julia using
#     julia --project
# to ensure that the associated project environment is activated

using DataFrames
df = DataFrame(a = 1:3)
combine(df, :a => sum => :a_sum)
select(df, :a => sum => :a_sum)

df = DataFrame(x1 = 1:3, x2 = 4:6)
combine(df, [:x1, :x2] .=> [sum minimum maximum])

[:x1, :x2] .=> [sum minimum maximum]

df = DataFrame(key1 = ["a", "b", "a", "b"],
                      key2 = [1, 2, 1, 2],
                      value = 1:4)
gdf = groupby(df, [:key1, :key2])
gdf[("b", 2)]

combine(gdf, :value => sum)
select(gdf, :value => sum)

using CSV, DataFrames, DataFramesMeta, Chain,
      Dates, HTTP, Plots, Statistics
input = "https://raw.githubusercontent.com/Rdatatable\
         /data.table/master/vignettes/flights14.csv"
flights = CSV.read(HTTP.get(input).body, DataFrame)
select!(flights, :year, :month, :origin, :dest, :dep_delay)
@chain flights begin
    groupby(:month, sort = true)
    combine(:dep_delay => mean)
    transform(:month => ByRow(monthname) => :month_name)
    @aside show(sort(_, :dep_delay_mean))
    plot(_.month_name, _.dep_delay_mean, label = nothing,
         xlabel = "Month", ylabel = "Mean delay", xrotation = 15)
    savefig("../Figures/flights.pdf")
end;
@chain flights begin
    groupby(:month, sort = true)
    @combine(:dep_delay_mean = mean(:dep_delay))
    @rtransform(:month_name = monthname(:month))
    @aside show(sort(_, :dep_delay_mean))
    plot(_.month_name, _.dep_delay_mean, label = nothing,
         xlabel = "Month", ylabel = "Mean delay", xrotation = 15)
    savefig("../Figures/flights.pdf")
end;
