#!/bin/bash

set -ueo pipefail

echo 'Running Julia benchmark...'
{
    pushd julia
    JULIA_BENCHMARK=$(
        source ./run_docker.bash 2>&1 | grep -oP '^\s+\K[0-9.]* ms' | grep -oP '\K[0-9.]*'
    )
    popd
} 2>&1 > /dev/null

JULIA_BENCHMARK=(${JULIA_BENCHMARK[@]})

echo 'Running MATLAB benchmark...'
MATLAB="${MATLAB:-$(which matlab)}"
MATLAB_BENCHMARK=$(
    $MATLAB -sd matlab -batch replication_script 2>&1 | grep -oP '^Timing:\s+\K[0-9]*\.[0-9]{3}'
)

echo 'Running Python benchmark...'
{
    pushd python
    PYTHON_BENCHMARK=$(
        source ./run_docker.bash 2>&1  | grep -oP '^Timing:\s+\K[0-9.]* ms' | grep -oP '\K[0-9]*[.][0-9]{3}'
    )
    popd
} 2>&1 > /dev/null

echo 'Running R benchmark...'
{
    pushd r
   R_BENCHMARK=$(
      source ./run_docker.bash 2>&1  | grep -oP 'Timing:\s+\K[0-9.]*\s+ms' | grep -oP '\K[0-9]*[.][0-9]{3}'
   )
   popd
} 2>&1 > /dev/null

R_BENCHMARK=(${R_BENCHMARK[@]})

echo
echo 'Univariate benchmark results:'
echo '-----------------------------'
printf "Julia:    %7.3f\n" ${JULIA_BENCHMARK[0]}
printf "MATLAB:   %7.3f\n" $MATLAB_BENCHMARK
printf "python:   %7.3f\n" $PYTHON_BENCHMARK
printf "R:        %7.3f\n" ${R_BENCHMARK[0]}
echo
echo 'Multivariate benchmark results:'
echo '-------------------------------'
printf "Julia (default):     %9.3f\n" ${JULIA_BENCHMARK[1]}
printf "Julia (twostep):     %9.3f\n" ${JULIA_BENCHMARK[2]}
printf "R:                   %9.3f\n" ${R_BENCHMARK[1]}
