#!/usr/bin/env python3

import os
import timeit
import functools
import numpy as np
import pandas as pd
from arch.univariate import arch_model

if __name__ == "__main__":
    data = pd.read_csv(os.path.join("data", "data.txt")).to_numpy().flatten()
    am = arch_model(data)
    N = 1000
    print(am.fit(disp="off"))
    print(am.fit(disp="off", backcast=np.var(data)))
    print("Benchmarking...")
    t = timeit.Timer(functools.partial(am.fit, disp="off"))
    r = t.repeat(N, 1)
    print("Timing: {} ms.".format(min(r) * 1000))
