library("rugarch")
library("rmgarch")
library("microbenchmark")

data(dmbp)
rets <- data.matrix(read.csv("data/dow29.csv"))

uspec <- ugarchspec(
  variance.model=list(model="sGARCH", garchOrder=c(1, 1)),
  mean.model=list(armaOrder=c(0, 0), include.mean=TRUE)
)
print(ugarchfit(data=dmbp, spec=uspec))

mspec <- multispec(replicate(29, uspec))
spec <- dccspec(uspec = mspec, dccOrder = c(1,1), 
               distribution = "mvnorm")
print(dccfit(spec, data = rets, fit.control = list(eval.se=TRUE)))

print("Benchmarking...")

min_t <- 1e6
# only run 10 estimations, given how long it takes to run
for (i in 1:10) {
    t <- summary(microbenchmark(ugarchfit(data=dmbp, spec=uspec), times=100))[2];
    if (t < min_t) {
        min_t <- t;
    }
}
print(paste("Timing: ", min_t, " ms."))

myfit <- function(spec, mspec, data, cluster){
  multf <- multifit(mspec, data, cluster=cluster)
  fit <- dccfit(spec, data = data, fit.control = list(eval.se=FALSE), fit=multf) # passing cluster=cl here as well makes it slower for me
  return(fit)
}
min_t <- 1e6
cl <- makePSOCKcluster(detectCores(logical=FALSE))
for (i in 1:3) {
    t <- summary(microbenchmark(myfit(spec, mspec, rets, cl), times=5))[2];
    if (t < min_t) {
      min_t <- t;
    }
}
stopCluster(cl)
print(paste("Timing: ", min_t * 1000, " ms."))


