The following commands assume `/gcimpute_replication_JSS` is your working
directory

## Preparation 

Unzip `Code` and `Figures`  for running the code and writing the output.

## Software installation

To install required packages, run the following line in the command line:

```
python3 -m pip install -r requirements.txt
```

To install our python package, unzip gcimpute-0.0.4.tar.gz and run the following
in the command line (replace the `[path-to-gcimpute-0.0.4]` with your path)

```
python3 -m pip install [path-to-gcimpute-0.0.4]/
```

You can also install the package from PyPI by running the following line in the
command line:

```
python3 -m pip install gcimpute==0.0.4
```

Note our package requires Python>=3.7 and we note the package runs into deprecation error (np.bool) under Python 3.10. We will update the package to address this deprecation. To use this version, please use Python version 3.8.

## Experiments replication

You can either replicate the codes in the interative jupyter notebook
experiments_notebook.ipynb or in the command line. Replication is easy using
either the command line (run a single line as shown below) or the jupyter
notebook (run all cells), but the notebook makes it more convenient to play the
software. 

To replicate in the command line, first make sure `matplotlib>=3.5.3` so that
plots can be generated. If needed, run the following to update `matplotlib`.

```
python3 -m pip install -Iv matplotlib==3.5.3
```

Then run the following line:

```
python3 Code/experiments.py > Figures/print_output.txt
```

It takes around 3 mins to finish. Then under the subdirectory Figures, the file
print_output.txt will collect all printed information, and the file
plots_output.pdf will collect all plotted images. Examples output files are
included in directory example_output.

