library(holiglm)

# set small to FALSE to create benchmark data from paper
small <- TRUE

if (small) {
    nobs <- 100
    nvars <- 20
} else {
    nobs <- 1000
    nvars <- 40
}


data_dir <- normalizePath("data")
dir.create(data_dir, showWarnings = FALSE, recursive = TRUE)

create_data <- function(params, fam) {
    data <- vector(mode="list", length=nrow(params))
    for (i in seq(nrow(params))) {
        nobs <- params[i, "nobs"]
        p <- params[i, "p"]
        k <- ceiling(p/2)
        beta <- c(1, rep(1L, k), double(p-k))
        data[[i]] <- rhglm(n=nobs, beta=beta, family=fam, truncate_mu = TRUE)
    }
    data
}

df <- expand.grid(run=1:10, nobs=nobs, p=seq(5, nvars, 5))

## Simulate gaussian data
set.seed(1)
data <- create_data(df, gaussian())
ofi <- file.path(data_dir, "gauss.rds")
saveRDS(data, ofi)

## Simulate binomial data
set.seed(1)
data <- create_data(df, binomial())
ofi <- file.path(data_dir, "binomial.rds")
saveRDS(data, ofi)

## Simulate poisson data
set.seed(1)
data <- create_data(df, poisson())
ofi <- file.path(data_dir, "poisson.rds")
saveRDS(data, ofi)

# model size
if (small) {
    nobs <- 1000
    nvars <- 30
} else {
    nobs <- 10000
    nvars <- 60
}

df <- expand.grid(nobs=as.integer(seq(100, nobs, length.out=10)), p=seq(5,nvars,5))

## Simulate gaussian data
set.seed(1)
data <- create_data(df, gaussian())
ofi <- file.path(data_dir, "gauss_size.rds")
saveRDS(data, ofi)

## Simulate binomial data
set.seed(1)
data <- create_data(df, binomial())
ofi <- file.path(data_dir, "binomial_size.rds")
saveRDS(data, ofi)

## Simulate poisson data
set.seed(1)
data <- create_data(df, poisson())
ofi <- file.path(data_dir, "poisson_size.rds")
saveRDS(data, ofi)
