# run generate.r before to create data

library(holiglm)
library(data.table)

result_dir <- normalizePath("results")
dir.create(result_dir, showWarnings = FALSE, recursive = TRUE)

# track object size

## gauss data
gauss <- readRDS('data/gauss_size.rds')
solver <- "gurobi"
# warmup solver
hglm(mpg~., data=mtcars, solver=solver)

result <- data.table(i=seq_along(gauss))
message("Gaussian:")
for (i in seq_along(gauss)) {
    message(i/length(gauss)*100, "%")
    data <- gauss[[i]]
    time_hglm <- system.time(model_hglm <- hglm(y~., data=data, family=gaussian(), solver=solver, object_size = "normal"))[[3]]
    time_hglm_big <- system.time(model_hglm_big <- hglm(y~., data=data, family=gaussian(), solver=solver, object_size = "big"))[[3]]
    time_glm  <- system.time(model_glm  <- glm(y~., data=data, family=gaussian()))[[3]]

    set(result, i=i, j="n", value=nrow(data))
    set(result, i=i, j="p", value=ncol(data)-1L)

    set(result, i=i, j="size_hglm", value=format(object.size(model_hglm), unit="Mb"))
    set(result, i=i, j="size_hglm_big", value=format(object.size(model_hglm_big), unit="Mb"))
    set(result, i=i, j="size_glm",  value=format(object.size(model_glm), unit="Mb"))
}

result
ofi <- file.path(result_dir, "gauss_size.rds")
saveRDS(result, ofi)

## binomial data
binomial <- readRDS('data/binomial_size.rds')
solver <- "ecos"
# warmup solver
hglm(group ~ ., data=PlantGrowth, family=binomial(), solver=solver)

result <- data.table(i=seq_along(binomial))
message("Binomial:")
for (i in seq_along(binomial)) {
    message(i/length(binomial)*100, "%")
    data <- binomial[[i]]
    time_hglm <- system.time(model_hglm <- hglm(y~., data=data, family=binomial(), solver=solver, object_size="normal"))[[3]]
    time_hglm_big <- system.time(model_hglm_big <- hglm(y~., data=data, family=binomial(), solver=solver, object_size="big"))[[3]]
    time_glm  <- system.time(model_glm  <- glm(y~., data=data, family=binomial()))[[3]]

    set(result, i=i, j="n", value=nrow(data))
    set(result, i=i, j="p", value=ncol(data)-1L)

    set(result, i=i, j="size_hglm", value=format(object.size(model_hglm), unit="Mb"))
    set(result, i=i, j="size_hglm_big", value=format(object.size(model_hglm_big), unit="Mb"))
    set(result, i=i, j="size_glm",  value=format(object.size(model_glm), unit="Mb"))
}

result
ofi <- file.path(result_dir, "binomial_size.rds")
saveRDS(result, ofi)

## poisson data
poisson <- readRDS('data/poisson_size.rds')
solver <- "ecos"
# warmup solver
hglm(Assault ~ ., data=USArrests, family=poisson(), solver=solver)

result <- data.table(i=seq_along(poisson))
message("Poisson:")
for (i in seq_along(poisson)) {
    message(i/length(poisson)*100, "%")
    data <- poisson[[i]]
    time_hglm <- system.time(model_hglm <- hglm(y~., data=data, family=poisson(), solver=solver, object_size="normal"))[[3]]
    time_hglm_big <- system.time(model_hglm_big <- hglm(y~., data=data, family=poisson(), solver=solver, object_size="big"))[[3]]
    time_glm  <- system.time(model_glm  <- glm(y~., data=data, family=poisson()))[[3]]

    set(result, i=i, j="n", value=nrow(data))
    set(result, i=i, j="p", value=ncol(data)-1L)

    set(result, i=i, j="size_hglm", value=format(object.size(model_hglm), unit="Mb"))
    set(result, i=i, j="size_hglm_big", value=format(object.size(model_hglm_big), unit="Mb"))
    set(result, i=i, j="size_glm",  value=format(object.size(model_glm), unit="Mb"))
}

result
ofi <- file.path(result_dir, "poisson_size.rds")
saveRDS(result, ofi)
