# Replication Manual for holiglm

This `README.md` provides instructions for replicating the results of Section 5 in the **Holistic Generalized Linear Models** paper.

To replicate the results, follow the five steps outlined below. Instead of running the individual scripts one by one, you can simply run `run.R` which will then call all the scripts.

## Step 1: Install Dependencies

Begin by installing the required dependencies. Run the following command in a shell:

```sh
Rscript install_packages.R
``` 

This command will install the necessary packages, including the data packages for plotting and result evaluation.
Additionally, ensure that you have installed the **holiglm** package. 
You can install it either by running the command `R CMD INSTALL holiglm_*.tar.gz` or via **CRAN** using the command `Rscript -e 'install.packages("holiglm")'`.

## Step 2: Generate Data

There are two options for generating the simulated data.
If you wish to reproduce the exact results described in the paper, set `small <- FALSE` in the `generate.R` script.
Please note that running with `small <- FALSE` may take a significant amount of time.
In any case, generate the data by executing the following command:

```sh
Rscript generate.R
```

## Step 3: Run Simulations

With the generated data in place, you can now run the simulation scenarios.
The order of execution does not matter.
Run the following commands to perform the simulations:

```sh
Rscript sim_bss.R
Rscript sim_linCon.R
Rscript sim_modelSize.R
```

The results will be stored in the **results** directory.

## Step 4: Create Evaluation Tables

Finally, create the result tables by running the following command:
```sh
Rscript eval.R
```

Upon completion, the evaluation tables will be generated.

## Step 5: Run Replication Script

With the data and results in place, execute the replication script via `Rscript v108i07.R`, which contains the code and plots of the paper.
By following these five steps, you should be able to replicate the results presented in the **Holistic Generalized Linear Models** paper.
