# ---- Helper functions for this script ----

## Facilitates user input regardless of how this script was invoked
user_decision <- function(prompt, allowed_answers = c("y", "n")) {
  
  if (interactive()) {
    answer <- readline(paste0(prompt, "\n"))
  } else {
    cat(prompt)
    answer <- readLines("stdin", n = 1)
  }
  
  answer <- tolower(answer)
  
  if (!(answer %in% allowed_answers)) {
    cat(paste0("Please enter ", paste(allowed_answers, collapse = " or "), ".\n"))
    answer <- user_decision(prompt, allowed_answers = allowed_answers)
  }
  
  return(answer)
}

# ---- Install dependencies ----

install_depends <- user_decision("Do you want to automatically install package dependencies? (y/n)")
if (install_depends == "y") {
  pkgs <- c("maps", "devtools", "dplyr", "DHARMa", "foreach", "FRK",
            "fmesher", "ggmap", "ggplot2", "ggpubr", "gstat",
            "htmlTable", "mgcv" , "plyr", "pROC" , "R.utils" , "raster",
            "reshape2", "scales", "scoringRules", "sp", "sf",
            "spacetime", "spBayes", "splancs" , "spNNGP", "stringr",
            "tibble", "tidyr", "INLA", "htmltab", "georob")
  req <- sapply(pkgs, require, char = TRUE, quietly = TRUE)
  if(!req["INLA"]){
    install.packages("INLA", repos="https://inla.r-inla-download.org/R/stable", dep = TRUE)
    req[!req["INLA"]] <- require("INLA", char = TRUE)
  }
  if(!req["htmltab"]){
    devtools::install_github("crubba/htmltab")
    req[!req["htmltab"]] <- require("htmltab", char = TRUE)
  }
  if (!all(req)){
    sapply(pkgs[!req], install.packages, repos = "https://cloud.r-project.org")
    req[!req] <- sapply(pkgs[!req], require, char = TRUE)
  }
  if (!all(req))
    stop("cannot load dependencies")
}


# ---- Check that the data has been downloaded correctly ----

downloaded_correctly <- c(
  file.exists("Data/chicago_crime_df.Rda"),
  # Check that the Sydney SA directories exist:
  file.exists("Data/Sydney_shapefiles/SA1"), 
  file.exists("Data/Sydney_shapefiles/SA2"), 
  file.exists("Data/Sydney_shapefiles/SA3"),
  # Check that the shapefiles exist:
  file.exists("Data/Sydney_shapefiles/SA1/SA1_2011_AUST.shp"), 
  file.exists("Data/Sydney_shapefiles/SA2/SA2_2011_AUST.shp"), 
  file.exists("Data/Sydney_shapefiles/SA3/SA3_2011_AUST.shp")
)
names(downloaded_correctly) <- c("SA1", "SA2", "SA3", "chicago_crime_df.Rda")
if(!all(downloaded_correctly)) {
  stop(paste0(
    "Some files have not been downloaded or are in the wrong place.\nProblematic files: \n", 
    names(downloaded_correctly)[!downloaded_correctly], 
    "\nIf on a unix system, run 'bash DATA.sh', otherwise please see the README for download instructions."
  ))
}

dir.create("Figures", showWarnings = FALSE)
dir.create("intermediates", showWarnings = FALSE)
