message("Beginning copula plots (Figure 1)...")
library(copula)

cops = list(frankCopula(4), 
            frankCopula(-2), 
            normalCopula(-.8), 
            normalCopula(.5)
          )

ns = rep(c("fr", "norm"), each=2)
dep = c(4,2,8,5)

row = 1:4
col = 1:4

for(i in seq_along(cops)){
  iter = 1
  
  a = wireframe2(cops[[i]], dCopula, delta=0.01, col="gray50", 
                 shade=TRUE, draw.4.pCoplines = FALSE, zlab="", xlim=c(.001,.999), ylim=c(.001,.999))
  a[["par.settings"]][["axis.text"]][["cex"]]=1.75
  a[["par.settings"]][["par.xlab.text"]][["cex"]]=2
  a[["par.settings"]][["par.ylab.text"]][["cex"]]=2
  
  png(paste0("Figures/fig1_", row[iter], col[i], ".png"))
    print(a)
  dev.off()
  print(a)
  
  iter = iter + 1
  
  png(paste0("Figures/fig1_", row[iter], col[i], ".png"))
    contour(cops[[i]], dCopula, labcex = 1.5, nlevels=15, delta=.03, cex.axis=2, cex.lab=3, ylab="")
    title(ylab=quote(u[2]), cex.lab=3, line=2.2)
  dev.off()
  contour(cops[[i]], dCopula, labcex = 1.5, nlevels=15, delta=.03, cex.axis=2, cex.lab=3, ylab="")
  
  iter = iter + 1
  
  a = wireframe2(cops[[i]], pCopula, delta=0.01, col="gray50", 
             shade=TRUE, drape=F, draw.4.pCoplines = FALSE, zlab="", xlim=c(.001,.999), ylim=c(.001,.999))
  a[["par.settings"]][["axis.text"]][["cex"]]=1.75
  a[["par.settings"]][["par.xlab.text"]][["cex"]]=2
  a[["par.settings"]][["par.ylab.text"]][["cex"]]=2
  
  png(paste0("Figures/fig1_", row[iter], col[i], ".png"))
    print(a)
  dev.off()
  print(a)
  
  iter = iter + 1

  png(paste0("Figures/fig1_", row[iter], col[i], ".png"))
    contour(cops[[i]], pCopula, labcex=2, nlevels=15, delta=.03, cex.axis=2, cex.lab=3, ylab="")
    title(ylab=quote(u[2]), cex.lab=3, line=2.25)
  dev.off()
  contour(cops[[i]], pCopula, labcex=2, nlevels=15, delta=.03, cex.axis=2, cex.lab=3, ylab="")
  

}

message("Figure 1 Copula plots complete.")

