message("Installing replication dependencies...")

pks = c(
  "bizicount",
  "dplyr",
  "tidyr",
  "ggplot2",
  "copula",
  "doParallel",
  "doRNG",
  "RhpcBLASctl"
)

needed = setdiff(pks, rownames(installed.packages()))

options(Ncpus = parallel::detectCores()-1)
if(length(needed) > 0){
  message("Installing needed packages: ", paste(needed, collapse=", "))
  install.packages(needed, repos = "https://cloud.r-project.org/", clean=TRUE, quiet=TRUE)
}

message("Attempted installation of dependencies completed.")


suppressMessages(invisible(sapply(pks, library, character.only=TRUE)))

sink("sessioninfo.txt", split=TRUE)

print(sessionInfo())

sink()
