# Figures

To reproduce the figures shown in the manuscript run the following scripts.

## Download data

To download the raw data files and apply the same preprocessing techniques, run

```bash
bash generate_h5ad.sh
```

This script generates `.h5ad` files, which are much easier (and faster) to work with. However, generating these fiels can take a very long time, so we have uploaded the already prepared `.h5ad` files to `file.biolab.si/opentsne`. To download the required files, run

```bash
bash download_h5ad.sh
```

## Generate figures

Once you have obtained the preprocessed .h5ad files, you can replicate the exact [conda](https://docs.conda.io/en/latest/miniconda.html) environment used to generate the figures from the manuscript. The environment can be installed and activated by running

```bash
conda env create -f conda-environment.yml
conda activate tsne-paper
```

The figures (excluding benchmarks) from the manuscript can then be generated by running

```bash
bash generate_figures.sh
```

## Scripts

### `fig1-macosko.py`

![](png/macosko2015.png)

### `fig3-iris.py`

![](png/iris.png)
![](png/iris-transform.png)

### `fig5-tasic.py`

![](png/tasic2018.png)

### `fig6-cao.py`

![](png/cao2019.png)

### `fig7-hocherner.py`

![](png/transform_hochgerner.png)
