# Run the three methods on the Hes1 model, 100 repetitions each
# For simplicity this script runs everything sequentially on a single CPU core, but the repetitions can be run in parallel to reduce the time needed to complete the benchmark

nseeds <- 100

for (i in 1:nseeds) {
  system(paste0("Rscript collocInfer-hes1.R ", i))
}

for (i in 1:nseeds) {
  system(paste0("Rscript MAGI-hes1.R ", i))
}

for (i in 1:nseeds) {
  system(paste0("Rscript deBInfer-hes1.R ", i))
}


# Summarize results of the three methods
rmse_CollocInfer <- matrix(NA, nrow = nseeds, ncol = 3)
theta_CollocInfer <- matrix(NA, nrow = nseeds, ncol = 7)
timeUsed_CollocInfer <- c()
for (seed in 1:nseeds) {
  if (file.exists(paste0("results/CollocInfer/Hes1-log-",seed,".rda"))) {
    load(file = paste0("results/CollocInfer/Hes1-log-",seed,".rda")) 
    
    rmse_CollocInfer[seed,] <- rmse_orig
    theta_CollocInfer[seed,] <- best.pars
    timeUsed_CollocInfer[seed] <- TimeUsed
  }
}


rmse_MAGI <- matrix(NA, nrow = nseeds, ncol = 3)
theta_MAGI <- matrix(NA, nrow = nseeds, ncol = 7)
timeUsed_MAGI <- c()

for (seed in 1:nseeds) {
  if (file.exists(paste0("results/magi/Hes1-log-",seed,".rda"))) {
    load(file = paste0("results/magi/Hes1-log-",seed,".rda")) 
    
    rmse_MAGI[seed,] <- rmse_orig
    theta_MAGI[seed,] <- theta.est
    timeUsed_MAGI[seed] <- TimeUsed
  }
}

rmse_deBInfer <- matrix(NA, nrow = nseeds, ncol = 3)
theta_deBInfer <- matrix(NA, nrow = nseeds, ncol = 7)
timeUsed_deBInfer <- c()

for (seed in 1:nseeds) {
  if (file.exists(paste0("results/deBInfer/Hes1-log-",seed,".rda"))) {
    load(file = paste0("results/deBInfer/Hes1-log-",seed,".rda")) 
    
    rmse_deBInfer[seed,] <- rmse_orig
    theta_deBInfer[seed,] <- theta.est
    timeUsed_deBInfer[seed] <- TimeUsed
  }
}

save(rmse_CollocInfer, theta_CollocInfer, timeUsed_CollocInfer,
    rmse_MAGI, theta_MAGI, timeUsed_MAGI,
    rmse_deBInfer, theta_deBInfer, timeUsed_deBInfer, file = "../data/Section5_benchmark.rda")

