# Full replication script for Figure 9 (Effect of hyperparameter values phi)

library(magi)

seeds <- 100

# Run 100 repetitions with different random seeds. Can be done in parallel.
for (i in 1:seeds) {
  system(paste0("Rscript HIV-random-phi.R ", i))
}

# Read summary data and parse for Figure 9
HIVsummary <- list()
for (seed in 1:seeds) {
  load(paste0("random-phi-", seed, ".rda"))
  HIVsummary[[seed]] <- summary(HIVresult, digits = 6)
}

saveRDS(HIVsummary, file = "../data/Figure9_results.rds")
