
# Extreme value analysis in Julia

*Extremes.jl* provides exhaustive high-performance functions for the analysis of extreme values in Julia. In particular, methods for block maxima and threshold exceedances models are implemented, such as:
* Parameter estimation by probability weighted moments, maximum likelihood and Bayesian procedure.
* Stationary and non-stationary models.
* Diagnostic plots for assessing model accuracy.
* Return level estimation.

The package is largely based on the books of Coles (2001), [An Introduction to Statistical Modeling of Extreme Values](http://www.springer.com/us/book/9781852334598), and of Beirlant *et al.* (2004) [Statistics of Extremes: Theory and Applications](https://www.wiley.com/en-us/Statistics+of+Extremes%3A+Theory+and+Applications-p-9780471976479). The *Tutorial* section illustrates the package functionalities by reproducing many results obtained by Coles (2001).
