# Replication code `deeptrafo`

## Installation

To install `deeptrafo` run
```r
remotes::install_github("https://github.com/neural-structured-additive-learning/deeptrafo")
```
for the development version or
```r
install.packages("deeptrafo")
```
for the stable version from CRAN.


## Requirements

The requirements are given in the `dependencies.R` file and can be installed by
sourcing the R script or `make dependencies`. If you set up a Python
environment for the first time, install `reticulate` and run the
`check_and_install()` function from the `deepregression` package. This tries to
install miniconda, tensorflow 2.10.0, tensorflow-probability 0.16 and keras
2.10.0. Should this not work, manually install conda, create an environment
with Python 3.10 and install the packages using `pip`:

```
conda create -n deeptrafo python=3.10
conda activate deeptrafo
pip install numpy==1.26.1 tensorflow==2.10 tensorflow-probability==0.16
```

Finally, add/uncomment the following line to `v111i10.R` after loading the packages:

```r
use_condaenv("deeptrafo") 
```

## Reproducing the results

1. Install dependencies via `make dependencies` or sourcing `dependencies.R`

2. Preprocess the `movies` data with `make data` or sourcing `movies.R`

3. Reproduce the results via `make repro` or sourcing `v111i10.R`

Simply run `make all` for all of the above.


## Troubleshooting

See
[here](https://github.com/neural-structured-additive-learning/deepregression/blob/main/README.md#troubleshooting)
for troubleshooting your Python/R installation.


## Movies data

The data `movies.csv` is licensed under CC0 and available in raw form from
[kaggle](https://www.kaggle.com/datasets/rounakbanik/the-movies-dataset).

