#  Replication of the results of the manuscript "TrueSkill Through Time: reliable initial skill estimates and historical comparability with Julia, Python and R"

Author: Gustavo Landfried
Author: Esteban Mocskos

1. Setup
    1. Julia Setup
    2. Python Setup
    3. R Setup
2. make Examples
3. make Figures
4. make Table1

---------------------------------------

## 1. Setup

Before running the code, install the packages used by each programming languages.
We specify the details of each one in the next subsections.

### 1.1 Julia SETUP

In `Julia` (at least 1.5, tested on 1.10.3) we use the packages `TrueSkillThroughTime`, `CSV`, `Dates`, `DataFrames`.
To install them, open the Julia console and execute the following code: 

```
using Pkg
Pkg.add("TrueSkillThroughTime")
Pkg.add("CSV")
Pkg.add("Dates")
Pkg.add("DataFrames")
```

### 1.2 Python SETUP

In Python3 (tested on 3.10.4, 3.10.12), we use the packages `trueskillthroughtime`, `pandas`, `numpy`, `python-dateutil`.
To install them, in a terminal execute the following code (some adjustments may be necessary depending on the operating system):

```
pip install trueskillthroughtime
pip install pandas
pip install numpy
pip install python-dateutil
```

### 1.3 R SETUP

In R (tested on 4.1.2), we use the packages `TrueSkillThroughTime`, `microbenchmark` and `hash`.}
To install them, open the R console and execute the following code:

```
install.packages("TrueSkillThroughTime")
install.packages("microbenchmark")
install.packages("hash")
```

---------------------------------------
## 2. make Examples

Executing `make Examples` in the root will execute the examples shown in the illustrations section.

- `TrueSkillThroughTime.jl/example.jl`
- `TrueSkillThroughTime.py/example.py`
- `TrueSkillThroughTime.R/example.R`

Also, the execution time reported in section Computational Details will be stored at:

- `./output/runtimes.csv`

Each column of this files summarizes one run time for each table (tables 2a, 2b, 3, 4 and 5).

---------------------------------------
## 3. make Figures

Executing `make Figures` in the root will trigger the skill estimates performed in Illustrations section: skill evolution, ATP and ATP with ground.

- `TrueSkillThroughTime.py/logistic.py`
- `TrueSkillThroughTime.jl/atp.jl`
- `TrueSkillThroughTime.jl/atp_ground.jl`

The results will be stored in the folder:

- `./output/logistic.csv`
- `./output/logistics_mu.csv`
- `./output/atp_learning_curves.csv`
- `./output/atp_ground_learning_curves.csv`

And this process will also create the Figures 5, 6 and 7.

- `./Code/logistic.pdf`
- `./Code/atp.pdf`
- `./Code/atp_ground.pdf`

---------------------------------------
## 4. make Table1

**This procedure takes several hours. We precomputed this file to save this time, if you still want to re-generate it, rename or remove table1.csv**

Executing `make Table1` in the root will trigger the generation of Table 1.

- `TrueSkillThroughTime.jl/table1.jl`

The results will be stored in the folder:

- `./output/table1.csv`

The meaning of the columns are:

- `rate_train`: the geometric mean of the prior prediction of the training set.
- `N_TRAIN`: the size of the training set.
- `rate_test`: the geometric mean of the prior prediction of the testing set.
- `N_TEST`: the size of the testing set.
- `sigma`: the optimal uncertainty of the prior skill distributions.
- `gamma`: the optimal dynamic uncertainty.
- `p_draw`: the optimal draw probability.

