# Reproducibility Script
## Requirements
This script requires that the `bayesmixpy` interface is installed.
To do so, please navigate to the `../bayesmix/python` directory and install `bayesmixpy` using pip:
```
cd python
pip3 install -r requirements.txt
pip3 install -e .
```
If the editable installation (`-e`) is not available, export the enviromnental variable `BAYESMIX_HOME=path_to_bayesmix_root_dir` and then run

```
cd python
pip3 install -r requirements.txt
pip3 install .
```

After installing `bayesmixpy`, `cd` back to this directory and install the following Python packages:
```
pip install arviz matplotlib numpy pandas
```

Finally, you have to install the `BNPmix` library against which we compare.
It can be installed by the regular R interpreter by running:
```
install.packages('BNPmix', dependencies = TRUE)
```

## Running the script
You can simply run the script with
```
python3 v112i09.py
```

All produced plots will be saved to the `Figures` directory.
