*****************************************************************************************
* Replication file for Cattaneo, Feng, Palomba, and Titiunik (2022)
*****************************************************************************************

*****************************************************************************************
** net install grc1leg, from("http://www.stata.com/users/vwiggins/") replace force
** net install scpi, from(https://raw.githubusercontent.com/nppackages/scpi/master/stata) replace force
*****************************************************************************************

* Load dataset
use "Data/scpi_germany.dta", clear

***********************************************
** One feature (gdp)

* Prepare data
scdata gdp, dfname("python_scdata") id(country) outcome(gdp) time(year) ///
			treatment(status) cointegrated constant

* Quantify uncertainty
local lgapp "linear"
foreach method in "simplex" "lasso" "ols" "ridge" "L1-L2"{
	if inlist("`method'", "ridge", "L1-L2") {
		local lgapp "generalized"
	} 
	scpi, dfname("python_scdata") name(`method') e_method(gaussian) ///
		  lgapp("`lgapp'") u_missp sims(1000) set_seed(8894)

	scplot, uncertainty("gaussian") gphoptions(note("") xtitle("Year") ///
		ytitle("GPD per capita (thousand US dollars)"))
}


***********************************************
** Multiple features (gdp, trade)
* Prepare data
scdata gdp trade, dfname("python_scdata") id(country) outcome(gdp) time(year) ///
			treatment(status) cointegrated covadj("constant")

* Quantify uncertainty
local lgapp "linear"
foreach method in "simplex" "lasso" "ols" "ridge" "L1-L2"{
	if inlist("`method'", "ridge", "L1-L2") {
		local lgapp "generalized"
	} 
	
	scpi, dfname("python_scdata") name(`method') e_method(gaussian) u_missp ///
		  lgapp("`lgapp'") sims(1000) set_seed(8894)

	scplot, uncertainty("gaussian") gphoptions(note("") xtitle("Year") ///
		ytitle("GPD per capita (thousand US dollars)")) joint
}

