from __future__ import absolute_import
from __future__ import print_function

import os
import shutil
import numpy as np
import pandas as pd
from multiprocessing import Process

def dataframe_from_csv(path, header=0, index_col=None):
    return pd.read_csv(path, header=header, index_col=index_col)


def remove_dir_if_exists(path):
    if os.path.exists(path) and os.path.isdir(path):
        shutil.rmtree(path)

def create_dir(path):
    os.makedirs(path)


def diff_nxt(arr):
    arr = np.array(arr, dtype='object')
    return np.concatenate(((arr[1:] != arr[:-1]), [False]))


def get_episode_IDs(ids, deltas):
    id_diff_nxt = diff_nxt(ids)
    deltas      = deltas.astype('bool')
    return        np.concatenate(([False], np.logical_or(id_diff_nxt, deltas))).astype('int').cumsum()[:-1]


def run_as_Ps(f_list, args_dict_list):

    P = []
    for f in f_list:
        for args_dict in args_dict_list:
            p=Process(target = f, kwargs = args_dict)
            p.start()
            P.append(p)

    for p in P:
        p.join()

def put_cols_first(data, cols):
    return data[cols+[col for col in data.columns if col not in cols]]

