/****************************************************************************************/
/*                                                          							*/
/*							SAS Macro newdatasetname.sas                   				*/
/*				SAS 9.4 TS Level 1M1 X64_7PROWindows NT Server-Version					*/
/*                                                          							*/
/****************************************************************************************/
/*                                                          							*/
/*	Creates a new temporary dataset name. Checks if the new datasetname _PROPOSALNAME	*/ 
/*	exist in the working directory. If not, _PROPOSALNAME is the new dataset name,  	*/
/*	else _PROPOSALNAMEX is the new dataset name (X is a natural number). 				*/
/*                                                          							*/
/****************************************************************************************/


%macro newdatasetname(PROPOSALNAME);
%local i newdatasetname;
%let proposalname=%sysfunc(compress(&proposalname));
%let newdatasetname=_&proposalname;

%do %while(%sysfunc(exist(&newdatasetname)));
	%let i = %eval(&i+1);
	%let newdatasetname=_&proposalname&i;
%end;

&newdatasetname
%mend newdatasetname;
