/****************************************************************************************************/
/*                                                          										*/
/*									SAS Macro renamevariable.sas                   					*/
/*						SAS 9.4 TS Level 1M1 X64_7PROWindows NT Server-Version						*/
/*                                                          										*/
/****************************************************************************************************/
/*                                                          										*/
/*	Renames a list of variables: Each member of the variable list OLDVARLIST gets a suffix SUFFIX.	*/ 
/*                                                          										*/
/****************************************************************************************************/


%macro renamevariable(OLDVARLIST, SUFFIX);
%local old k;
%let k=1;
%let old = %scan(&oldvarlist, &k);
%do %while("&old" NE "");
	rename &old = &old.&suffix;
	%let k = %eval(&k + 1);
 	%let old = %scan(&oldvarlist, &k);
%end;
%mend renamevariable;
