/*** Supplement to the Article: %SURVEYHLM: A SAS Macro for Multilevel Analysis with Large-scale Educational Assessment Data 
 								Kasper, D., Schulz-Heidorf, K. & Schwippert, K. 												
												Application (Model 1; 3 Levels)	***/

												
												
/*** Specify the path for the SAS data (dpath) and macro (mpath) files following the format x:\xxx\ ***/
/*** <datpath> and <macropath> must be edited ***/
%let dpath = <datpath>;
%let mpath = <macropath>;


	
/*** Libname path ***/
libname g "&dpath";



/*** Search path for format catalogs ***/
options fmtsearch=(g.t15_prep);



/*** Include macros ***/
%include "&mpath\renamevariable.sas";
%include "&mpath\newdatasetname.sas";
%include "&mpath\namep.sas";
%include "&mpath\pvarname.sas";
%include "&mpath\surveyhlm.sas";



/*** Run LMM ***/
/** Emprical based SE **/
%surveyhlm(DATN=T15_prep, ROOTPV=asmmat0, NPV=5, CVAR1=SLM_sca0, CVAR3=ACBG04d, XVAR2=AT_MEAN, 
GCENT=at_mean, NEST1=idstud, NEST2=idclass, nest3=idschool, WGT=MATWGT, L1WGT=WGT_L1, L2WGT=WGT_L2, L3wgt=WGT_L3, 
JKREP=JKREP, JKZONE=JKZONE, NRWGT=150, LABEL=model13, SRVYSAM=n,
TYPE2=UN, TYPE3=UN, QPOINTS=1, startrw=n, LIBD=&dpath, LIBE=&dpath);

/** Replication based SE **/
%surveyhlm(DATN=T15_prep, ROOTPV=asmmat0, NPV=5, CVAR1=SLM_sca0, CVAR3=ACBG04d, XVAR2=AT_MEAN, 
GCENT=at_mean, NEST1=idstud, NEST2=idclass, nest3=idschool, WGT=MATWGT, L1WGT=WGT_L1, L2WGT=WGT_L2, L3wgt=WGT_L3, 
JKREP=JKREP, JKZONE=JKZONE, NRWGT=150, LABEL=model13Lsyv, 
TYPE2=UN, TYPE3=UN, QPOINTS=1, startrw=n, LIBD=&dpath, LIBE=&dpath);
