/*** Supplement to the Article: %SURVEYHLM: A SAS Macro for Multilevel Analysis with Large-scale Educational Assessment Data 
 								Kasper, D., Schulz-Heidorf, K. & Schwippert, K. 												
												Application (Model 2)	***/



/*** Specify the path for the SAS data (dpath) and macro (mpath) files following the format x:\xxx\ ***/
/*** <datpath> and <macropath> must be edited ***/
%let dpath = <datpath>;
%let mpath = <macropath>;


	
/*** Libname path ***/
libname g "&dpath";



/*** Search path for format catalogs ***/
options fmtsearch=(g.p11_model2);



/*** Include macros ***/
%include "&mpath\renamevariable.sas";
%include "&mpath\newdatasetname.sas";
%include "&mpath\namep.sas";
%include "&mpath\pvarname.sas";
%include "&mpath\surveyhlm.sas";

												
												
/*** Run GLMM ***/
%surveyhlm(DATN=p11_model2, ROOTPV=bmhr0, NPV=5, CVAR1=bookr, cvar2=readtr, 
NEST1=idstud, NEST2=idschool, WGT=TCHWGT, L1WGT=studwgt, L2WGT=classwgt, 
JKREP=JKREP, JKZONE=JKZONE, NRWGT=75, JKTYP=half, JKFAC=1.0, SHRTCUT=y, LABEL=modell2syv, 
TYPE2=UN, dist=BINARY, startrw=n, QPOINTS=7, LIBD=&dpath, LIBE=&dpath);
