/*** Supplement to the Article: %SURVEYHLM: A SAS Macro for Multilevel Analysis with Large-scale Educational Assessment Data 
 								Kasper, D., Schulz-Heidorf, K. & Schwippert, K. 												
												Application (Model 3; UN)	***/



/*** Specify the path for the SAS data (dpath) and macro (mpath) files following the format x:\xxx\ ***/
/*** <datpath> and <macropath> must be edited ***/
%let dpath = <datpath>;
%let mpath = <macropath>;



/*** Libname path ***/
libname g "&dpath";



/*** Search path for format catalogs ***/
options fmtsearch=(g.p11_model3);



/*** Include macros ***/
%include "&mpath\renamevariable.sas";
%include "&mpath\newdatasetname.sas";
%include "&mpath\namep.sas";
%include "&mpath\pvarname.sas";
%include "&mpath\surveyhlm.sas";



/*** Run LMM ***/
/** Model 3 **/
%surveyhlm(DATN=P11_model3, ROOTPV=asrrea0, NPV=5, CVAR1=books, RSLOPE2=books, 
NEST1=idstud, NEST2=idschool, WGT=TCHWGT, L1WGT=studwgt, L2WGT=classwgt, 
JKREP=JKREP, JKZONE=JKZONE, NRWGT=75, JKTYP=half, JKFAC=1.0, SHRTCUT=y, LABEL=model3un,  
MAXFUNC=1500, TYPE2=UN, start=n, startrw=n, qpoints=1, GCONV=0.01, LIBD=&dpath, LIBE=&dpath);
