/*** Supplement to the Article: %SURVEYHLM: A SAS Macro for Multilevel Analysis with Large-scale Educational Assessment Data 
 								Kasper, D., Schulz-Heidorf, K. & Schwippert, K. 												
										Application (Model 1; 2 Levels)	***/

	

/*** Specify the path for the SAS data (dpath) and macro (mpath) files following the format x:\xxx\ ***/
/*** <datpath> and <macropath> must be edited ***/
%let dpath = <datpath>;
%let mpath = <macropath>;


	
/*** Libname path ***/
libname g "&dpath";



/*** Search path for format catalogs ***/
options fmtsearch=(g.t15_prep);



/*** Include macros ***/
%include "&mpath\renamevariable.sas";
%include "&mpath\newdatasetname.sas";
%include "&mpath\namep.sas";
%include "&mpath\pvarname.sas";
%include "&mpath\surveyhlm.sas";



/*** Run LMM ***/
%surveyhlm(DATN=T15_prep, ROOTPV=asmmat0, NPV=5,  CVAR1=SLM_sca0, CVAR2=ACBG04d, XVAR2=AT_MEAN, 
GCENT=at_mean, NEST1=idstud, NEST2=idclass, WGT=MATWGT, L1WGT=WGT_L1, L2WGT=WGT_L2o, 
JKREP=JKREP, JKZONE=JKZONE, NRWGT=150, LABEL=model12Lsyv, 
TYPE2=UN, QPOINTS=1, LIBD=&dpath, LIBE=&dpath);
