var documenterSearchIndex = {"docs":
[{"location":"statistics.html#Monitoring-statistics","page":"Monitoring statistics","title":"Monitoring statistics","text":"","category":"section"},{"location":"statistics.html","page":"Monitoring statistics","title":"Monitoring statistics","text":"Modules = [StatisticalProcessMonitoring]\nPages = [\"stats-interface.jl\", \"univariate.jl\", \"multivariate.jl\", \"residual.jl\", \"categorization.jl\", \"LLCUSUM.jl\", \"LLD.jl\", \"MOC.jl\", \"functional.jl\", \"NEWMA.jl\", \"adaptive-sampling.jl\", \"RSADA.jl\", \"TRAS.jl\"]","category":"page"},{"location":"statistics.html#StatisticalProcessMonitoring.AEWMA","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.AEWMA","text":"AEWMA(λ, k, value)\n\nAdaptive exponentially weighted moving average with design parameters λ, k, and initial value value.\n\nThe update mechanism for the statistic C_t based on a new observation x is given by\n\nC_t = (1-phi(e))cdot C_t-1 + phi(e) cdot x,\n\nwhere phi(e) is a forecast error function based on the Huber score function.\n\nArguments\n\nλ::Float64: The smoothing constant. Default is 0.1.\nk::Float64: The threshold value in the Huber score. Default is 3.0`.\nvalue::Float64: The initial value of the statistic. Default is 0.0.\n\nReferences\n\nCapizzi, G. & Masarotto, G. (2003). An Adaptive Exponentially Weighted Moving Average Control Chart. Technometrics, 45(3), 199-207.\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.CUSUM","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.CUSUM","text":"CUSUM(k, value, upw::Bool)\n\nCUSUM statistic with design parameter k and initial value value.\n\nThe update mechanism based on a new observation x is given by:\n\nif upw == true, then C_t = max0 C_t-1 + x - k;\nif upw == false, then C_t = min0 C_t-1 + x + k.\n\nArguments\n\nk::Float64: The allowance constant of the CUSUM statistic. Defaults to 1.0.\nvalue::Float64: The current value of the cumulative sum. Defaults to 0.0.\nupw::Bool: A boolean indicating whether the CUSUM statistic is increasing or decreasing. Defaults to true.\n\nReferences\n\nPage, E. S. (1954). Continuous Inspection Schemes. Biometrika, 41(1/2), 100. https://doi.org/10.2307/2333009\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.EWMA","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.EWMA","text":"EWMA(λ, value)\n\nExponentially weighted moving average with design parameter λ and initial value value.\n\nThe update mechanism for the statistic C_t based on a new observation x is given by\n\nC_t = (1-λ)cdot C_t-1 + λ cdot x.\n\nArguments\n\nλ::Float64: The smoothing constant. Defaults to 0.1.\nvalue::Float64: The initial value for the EWMA statistic. Defaults to 0.0.\n\nReferences\n\nRoberts, S. W. (1959). Control Chart Tests Based on Geometric Moving Averages. Technometrics, 1(3), 239-250. https://doi.org/10.1080/00401706.1959.10489860\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.OneSidedEWMA","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.OneSidedEWMA","text":"OneSidedEWMA(λ, value, upw::Bool)\n\nOneSidedEWMA statistic with design parameter λ and initial value value.\n\nThe update mechanism based on a new observation x is given by:\n\nif upw == true, then C_t = max0 (1-λ)cdot C_t-1 + λcdot x;\nif upw == true, then C_t = min0 (1-λ)cdot C_t-1 + λcdot x;\n\nArguments\n\nλ::Float64: The smoothing constant. Default is 0.1.\nvalue::Float64: The current value of the statistic. Default is 0.0.\nupw::Bool: Whether the statistic should monitor increases (true) or decrease (falses) in the process mean. Default is true.\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.Shewhart","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.Shewhart","text":"Shewhart(value)\n\nShewhart control chart.\n\nThe update mechanism of C_t based on a new observation x is given by\n\nC_t = x.\n\nReferences\n\nShewhart, W. A. (1931). Economic Control of Quality Of Manufactured Product. D. Van Nostrand Company.\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.WCUSUM","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.WCUSUM","text":"WCUSUM <: AbstractStatistic\n\nA weighted cumulative sum statistic.\n\nArguments\n\nk::Float64: The allowance constant of the CUSUM used for calculating the WCUSUM statistic. Default is 1.0.\nλ::Float64: The smoothing constant for updating the estimate of the fault signature. Must be a value between 0 and 1. Default is 0.2.\nvalue::Float64: The initial value of the weighted cumulative sum statistic. Default is 0.0.\nQ::Float64: The residual value of the weighted cumulative sum. Default is 0.0.\nupw::Bool: Whether to monitor increases in the mean (true) or decreases (false). Default is true.\n\nReferences\n\nShu, L., Jiang, W., & Tsui, K.-L. (2008). A Weighted CUSUM Chart for Detecting Patterned Mean Shifts. Journal of Quality Technology, 40(2), 194-213. https://doi.org/10.1080/00224065.2008.11917725\n\nExamples\n\nstat = WCUSUM()\nget_design(stat)            # returns [1.0, 0.2]\nupdate_statistic(stat, 3.0) # returns 1.2\nstat.Q                      # returns 0.6\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.ALT","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.ALT","text":"ALT{M}\n\nA Generalized Likelihood Ratio statistic for monitoring changes in the variance-covariance matrix.\n\nFields\n\nvalue::Float64: The value of the statistic, initialized to 0.0.\nΩ::M: The precision matrix of the in-control process.\ndetΣ::Float64: The determinant of the in-control process variance.\n\nReferences\n\nAlt, F. A. (1984). Multivariate quality control. In N. L. Johnson, S. Kotz, & C. R. Read (Eds.), The encyclopedia of statistical sciences (Vol. 6, pp. 110-122). Wiley.\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.AMCUSUM","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.AMCUSUM","text":"AMCUSUM(λ, p; minshift = 0.1, shift = 0.0, Et = zeros(p), t = 0, stat = MCUSUM(k=0.1, p=p))\n\nAn Adaptive Multivariate Cumulative Sum (MCUSUM) statistic.\n\nArguments\n\nλ::Float64: The smoothing constant, such that 0.0 <= λ <= 1.0.\np::Int: The number of quality variables to monitor.\nminshift::Float64: The minimum shift value to be detected. Default is 0.1.\nshift::Float64: The current shift value. Default is 0.0.\nEt::Vector{Float64}: The vector Et of smoothed deviations from the zero mean. Has to be exactly equal to zeros(p)\nt::Int: The current value of time. Default is 0.\nstat::C: The underlying classical MCUSUM statistic. Default is MCUSUM(k=0.1, p=p).\n\nReferences\n\nDai, Y., Luo, Y., Li, Z., & Wang, Z. (2011). A new adaptive CUSUM control chart for detecting the multivariate process mean. Quality and Reliability Engineering International, 27(7), 877-884. https://doi.org/10.1002/qre.1177\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.DiagMEWMA","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.DiagMEWMA","text":"DiagMEWMA(Λ, value)\n\nExponentially weighted moving average with diagonal smoothing matrix Λ and initial value value.\n\nThe update mechanism based on a new observation x is given by\n\nZ_t = (I-Λ)Z_t-1 + Λ x_t,\n\nand the chart value is defined as\n\nC_t = Z_t Λ^-1 Z_t.\n\nArguments\n\nΛ::Vector{Float64}: The vector of smoothing constants.\nvalue::Float64: Current value of the statistic (default = 0.0).\nz::Vector{Float64}: Vector of smoothed observations (Default: zeros(length(Λ))).\ninv_Σz::Matrix{Float64}: Inverse of the covariance matrix of the control variates.\n\nReferences\n\nLowry, C. A., Woodall, W. H., Champ, C. W., & Rigdon, S. E. (1992). A Multivariate Exponentially Weighted Moving Average Control Chart. Technometrics, 34(1), 46-53. https://doi.org/10.1080/00401706.1992.10485232\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.MAEWMA","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.MAEWMA","text":"MAEWMA(λ, k, value, z::Vector{Float64})\n\nA Multivariate Adaptive Exponentially Weighted Moving Average.\n\nThe update mechanism based on a new observation x is given by\n\nZ_t = (I-Ω)*Z_t-1 + Ω * x_t,\n\nwhere Ω = ω(e)*I is an adaptive generalization of the classical MEWMA smoothing matrix. The chart value is defined as\n\nvalue_t = Z_t Z_t.\n\nArguments\n\nλ::Float64: The value of the EWMA smoothing parameter.\nk::Float64: The value of the parameter of the Huber score.\nvalue::Float64: The value of the statistic. (default: 0.0)\nz::Vector{Float64}: The vector of smoothed observations.\n\nReferences\n\nMahmoud, M. A., & Zahran, A. R. (2010). A Multivariate Adaptive Exponentially Weighted Moving Average Control Chart. Communications in Statistics - Theory and Methods, 39(4), 606-625. https://doi.org/10.1080/03610920902755813\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.MCUSUM","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.MCUSUM","text":"MCUSUM(k, p, value = 0.0, St = zeros(p))\n\nA Multivariate Cumulative Sum (MCUSUM) statistic.\n\nArguments\n\nk::Float64: The value of the allowance parameter.\np::Int: The number of variables to be monitored. \nvalue::Float64: The initial value of the statistic. Default is 0.0.\nSt::Vector{Float64}: A vector representing the multivariate cumulative sum at the current time t.\n\nExamples\n\nstat = MCUSUM(0.25, 2, 0.0, [0.0, 0.0])\n\nReferences\n\nCrosier, R. B. (1988). Multivariate Generalizations of Cumulative Sum Quality-Control Schemes. Technometrics, 30(3), 291-303. https://doi.org/10.2307/1270083\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.MEWMC","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.MEWMC","text":"MEWMC(λ, value)\n\nAn Exponentially Weighted Moving Covariance Matrix statistic with smoothing constant λ and initial value value.\n\nThe update mechanism for C_t based on a new observation x \\in \\mathbb{R}^p is given by\n\nZ_t = (1 - λ)Z_t-1 + λ cdot xx,\n\nand the chart value is defined as\n\nC_t = texttr(Z_t) - logZ_t - p.\n\nReferences\n\nHawkins, D. M., & Maboudou-Tchao, E. M. (2008). Multivariate Exponentially Weighted Moving Covariance Matrix. Technometrics, 50(2), 155-166.\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.MEWMS","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.MEWMS","text":"MEWMS(λ, value)\n\nExponentially weighted moving covariance matrix with smoothing constant λ.\n\nThe update mechanism based on a new observation x \\in \\mathbb{R}^p is given by\n\nZ_t = (1 - λ)*Z_t-1 + λ cdot xx,\n\nand the chart value is defined as\n\n``valuet = \\text{tr}(Zt).\n\nReferences\n\nHuwang, L., Yeh, A. B., & Wu, C.-W. (2007). Monitoring Multivariate Process Variability for Individual Observations. Journal of Quality Technology, 39(3), 258-278. https://doi.org/10.1080/00224065.2007.11917692\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.MShewhart","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.MShewhart","text":"MShewhart(value)\n\nShewhart control chart for monitoring multivariate observations with initial value value.\n\nThe update mechanism of C_t based on a new observation x is given by\n\nC_t = xx.\n\nReferences\n\nShewhart, W. A. (1931). Economic Control of Quality Of Manufactured Product. D. Van Nostrand Company.\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.RiskAdjustedCUSUM","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.RiskAdjustedCUSUM","text":"RiskAdjustedCUSUM{G} <: AbstractStatistic\n\nRisk-adjusted CUSUM monitoring statistic.\n\nArguments\n\nΔ::Float64: Shift in the linear predictor of the logistic regression model to be detected.\nmodel::G: Logistic regression model used for prediction. Must have a predict(model, x) function.\nresponse::Symbol: Name of the response variable in the DataFrame.\nvalue::Float64: Initial value of the statistic. Defaults to 0.0.\n\nReferences\n\nSteiner, S. H., Cook, R. J., Farewell, V. T., Treasure, T. (2000). Monitoring surgical performance using risk-adjusted cumulative sum charts. Biostatistics, 1(4), 441-452. https://doi.org/10.1093/biostatistics/1.4.441 ```\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.LocationScaleStatistic","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.LocationScaleStatistic","text":"LocationScaleStatistic{S, M, P}\n\nA mutable struct representing a statistic applied to a location-scale family.\n\nFields\n\nstat::S: The statistic.\nμ::M: The location parameter.\nΩ::P: The inverse square root of the variance.\n\nExamples\n\nSTAT = EWMA(λ = 0.2)\nRSTAT = LocationScaleStatistic(STAT, 1.0, 2.5)\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.categorize_data-Tuple{AbstractVector, Vector{Vector{Float64}}}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.categorize_data","text":"categorize_data(x::AbstractVector, qtls::Vector{Vector{Float64}})\ncategorize_data(x::AbstractMatrix, qtls::Vector{Vector{Float64}})\n\nCategorize continuous data using the medians of the continuous variables.\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.compose-Tuple{Symbol, Tuple}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.compose","text":"compose(lhs::Symbol, rhs::Tuple)\ncompose(lhs::Symbol, rhs::Term)\ncompose(lhs::Symbol, rhs::ConstantTerm)\n\nCompose a response variable lhs with a tuple or vector of predictors rhs terms.\n\nArguments\n\nlhs::Symbol: The left-hand side of the equation.\nrhs::Tuple: The right-hand side of the equation.\n\nReturns\n\nThe composed equation.\n\nIf rhs is empty, the function returns lhs composed with an intercept. Otherwise, the function returns lhs composed with the terms in rhs.\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.get_removable_terms-Tuple{Any}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.get_removable_terms","text":"get_removable_terms(rhs)\n\nGiven an iterable collection of terms rhs, this function returns the indices of the terms in rhs that can be removed in a backward elimination step.\n\nArguments\n\nrhs: An iterable collection of terms in the equation.\n\nReturns\n\nAn array of indices of the terms in rhs that have the maximum order.\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.kronecker_matrix-Tuple{AbstractVector}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.kronecker_matrix","text":"kronecker_matrix(qtls::AbstractVector)\n\nCompute the matrix given by the Kronecker vectors according to Equation (6) of Wang et Al. (2017). This matrix is used to compute the approximate GLRT statistic to test the null hypothesis that the main effects and the second order interactions of a log-linear model are stable.\n\nReferences\n\nWang, J., Li, J., & Su, Q. (2017). Multivariate Ordinal Categorical Process Control Based on Log-Linear Modeling. Journal of Quality Technology, 49(2), 108-122. https://doi.org/10.1080/00224065.2017.11917983\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.quantile_range-Tuple{Any, Any, Any}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.quantile_range","text":"quantile_range(lower, upper, m)\n\nGet the set of quantiles needed to divide the data in m classes.\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.LLCUSUM","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.LLCUSUM","text":"LLCUSUM(x::AbstractMatrix, k::Real; ncuts::AbstractVector = [2 for _ in eachcol(x)])\n\nA distibution-free Log-Linear CUSUM monitoring statistic based on data categorization.\n\nFields\n\nk::Float64: The allowance constant of the CUSUM statistic.\nvalue::Float64: The initial value of the statistic (default: 0.0).\nSobs::Vector{Float64}: The vector of cumulative observed categories.\nSexp::Vector{Float64}: The vector of expected observed categories.\nqtls::Vector{Vector{Float64}}: A vector of quantiles used for data categorization.\nf0::Vector{Float64}: The vector of IC cell probabilities, estimated using a loglinear model.\ntable::Matrix{Float64}: The matrix of cell combinations.\n\nReferences\n\nQiu, P. (2008). Distribution-free multivariate process control based on log-linear modeling. IIE Transactions, 40(7), 664-677. https://doi.org/10.1080/07408170701744843\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.categorical_to_index-Tuple{AbstractVector, AbstractMatrix}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.categorical_to_index","text":"categorical_to_index(g::AbstractVector, table::AbstractMatrix)\n\nConverts a categorized variable g to its corresponding index in a table.\n\nArguments\n\ng::AbstractVector: The categorical variable to convert.\ntable::AbstractMatrix: The table containing all the possible categories.\n\nReturns\n\nInt: The index of the category in the table.\n\nRaises\n\nErrorException if the index is not found\n\nExample\n\nx = randn(500, 3)\ndf, table, qtls = create_table(x, [2 for _ in eachcol(x)])\nxnew = randn(3)\ng = categorize_data(xnew, qtls)\nidx = categorical_to_index(g, table)\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.estimate_loglinear_model_probabilities-Tuple{Any, Any}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.estimate_loglinear_model_probabilities","text":"estimate_ordinal_model_probabilities(df, table)\n\nEstimates the probabilities of an ordinal loglinear model based on the observed cell counts.\n\nArguments\n\ndf::DataFrame: The data frame containing the predictor variables.\ntable::AbstractMatrix: The matrix of predictor values for which probabilities are to be estimated.\n\nReturns\n\nprob::Vector{Float64}: A vector of estimated probabilities.\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.LLD","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.LLD","text":"LLD(x::AbstractMatrix, l::Real; ncuts::AbstractVector = [3 for _ in eachcol(x)], N = 1)\n\nA Log-Linear Directional monitoring statistic based on data categorization.\n\nFields\n\nl::Float64: The exponentially weighted smoothing constant of the statistic.\nvalue::Float64: The initial value of the statistic (default: 0.0).\nqtls::Vector{Vector{Float64}}: A vector of quantiles used for data categorization.\nf0::Vector{Float64}: The vector of IC cell probabilities, estimated using a loglinear model.\ntable::Matrix{Float64}: The matrix of cell combinations.\nSigma::Matrix{Float64}: The covariance matrix of the cell counts.\ndirections::Matrix{Float64}: The matrix of directions to be used in the hypohesis test (see Equation (6) of [Li, 2012]). This is calculated according to the procedure described in Equations (5) and (6) of [Wang, 2017].\nN::Int: The number of observations at each time point (default: 1)\nz_k::Vector{Float64}: The current vector of smoothed values.\n\nReferences\n\nLi, J., Tsung, F., & Zou, C. (2012). Directional Control Schemes for Multivariate Categorical Processes. Journal of Quality Technology, 44(2), 136â€“154. https://doi.org/10.1080/00224065.2012.11917889\n\nWang, J., Li, J., & Su, Q. (2017). Multivariate Ordinal Categorical Process Control Based on Log-Linear Modeling. Journal of Quality Technology, 49(2), 108-122. https://doi.org/10.1080/00224065.2017.11917983\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.MOC","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.MOC","text":"MOC(x::AbstractMatrix, l::Real; ncuts::AbstractVector = [3 for _ in eachcol(x)], N = 1)\n\nA Multivariate Ordinal Categorical monitoring statistic based on data categorization.\n\nFields\n\nl::Float64: The exponentially weighted smoothing constant of the statistic.\nvalue::Float64: The initial value of the statistic (default: 0.0).\nqtls::Vector{Vector{Float64}}: A vector of quantiles used for data categorization.\nf0::Vector{Float64}: The vector of IC cell probabilities, estimated using a loglinear model.\ntable::Matrix{Float64}: The matrix of cell combinations.\ninv_VCOV::Matrix{Float64}: The matrix containing the inverse covariance to be used in the running statistic.\nN::Int: The number of observations at each time point (default: 1)\nz_k::Vector{Float64}: The current vector of smoothed values.\n\nReferences\n\nWang, J., Li, J., & Su, Q. (2017). Multivariate Ordinal Categorical Process Control Based on Log-Linear Modeling. Journal of Quality Technology, 49(2), 108-122. https://doi.org/10.1080/00224065.2017.11917983\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.estimate_ordinal_model_probabilities-Tuple{DataFrames.DataFrame, Any}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.estimate_ordinal_model_probabilities","text":"estimate_ordinal_model_probabilities(df, table)\n\nEstimates the probabilities of an ordinal loglinear model based on the observed cell counts.\n\nArguments\n\ndf::DataFrame: The data frame containing the predictor variables.\ntable::AbstractMatrix: The matrix of predictor values for which probabilities are to be estimated.\n\nReturns\n\nprob::Vector{Float64}: A vector of estimated probabilities.\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.NEWMA","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.NEWMA","text":"NEWMA\n\nA Nonparametric Exponentially Weighted Moving Average statistic for monitoring profiles.\n\nFields\n\nλ::Float64: The EWMA smoothing constant. Must be between 0 and 1.\nvalue::Float64: The current value of the NEWMA statistic.\nσ::Float64: The standard deviation of the error term.\ncdf_σ::E: A function that computes the (estimated) cdf of the error term σ with signature cdf_σ(x::Real).\ng::F: The estimated regression function object. Must have a method of signature predict(g::F, x::AbstractVector).\nEj::Vector{Float64}: The current smoothed observations.\n\nReferences\n\nZou, C., Tsung, F., & Wang, Z. (2008). Monitoring Profiles Based on Nonparametric Regression Methods. Technometrics, 50(4), 512-526. https://doi.org/10.1198/004017008000000433\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.NEWMA-Tuple{Float64, Any, Array{FunctionalObservation{A, B}, 1} where {A, B}}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.NEWMA","text":"NEWMA(λ::Float64, g::F, dat::FunctionalData)\n\nConstruct a NEWMA control chart by calculating the standard errors for a functional regression model.\n\nArguments\n\nλ::Float64: The EWMA smoothing constant. Must be between 0 and 1.\ng::F: The estimated regression function object. Must have a method of signature predict(g::F, x::AbstractVector).\ndat::FunctionalData: A FunctionalData object containing observations of the regression curves.\nEj::Vector{Float64}: The current smoothed observations.\n\nReturns\n\nThe constructed NEWMA control chart.\n\nExamples\n\nusing Loess\nxs = 10 .* rand(100)\nys = sin.(xs) .+ rand(100)\ng = loess(xs, ys)\ndat = FunctionalData(xs, ys)\nNEWMA(0.2, g, dat)\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.AbstractSampling","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.AbstractSampling","text":"AbstractSampling\n\nAbstract type representing a generic sampling method for partially-observed data.\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.ThompsonSampling","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.ThompsonSampling","text":"ThompsonSampling <: AbstractSampling\n\nType representing the Thompson Sampling method.\n\nFields\n\nβ::Float64: A parameter regulating the concentration of the Dirichlet distribution for Thompson sampling.\n\nExamples\n\nts = ThompsonSampling(2.0)\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.TopQ","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.TopQ","text":"TopQ <: AbstractSampling\n\nType representing the TopQ sampling method. New data is generating by taking the q local statistics with highest value. \n\nReferences\n\nMei, Y. (2011). Quickest detection in censoring sensor networks. 2011 IEEE International Symposium on Information Theory Proceedings, 2148-2152. https://doi.org/10.1109/ISIT.2011.6034390\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.new_layout-Tuple{AbstractSampling, Any, Int64}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.new_layout","text":"new_layout(sampling::AbstractSampling, local_statistics) -> layout\n\nAbstract function that creates a new layout based on the given sampling method and local statistics.\n\nArguments\n\nsampler::AbstractSampling: An instance of an object subtype of AbstractSampling.\nlocal_statistics: Array of local statistics used for generating the layout.\nq::Int: The number of items to include in the layout.\n\nReturns\n\nlayout: The generated layout to observe at the next iteration.\n\nExamples\n\n# Create an instance of ThompsonSampling\nts = ThompsonSampling(2.0)\n\n# Generate a layout using ThompsonSampling\nstats = [1, 2, 3, 4]\nlayout = new_layout(ts, stats, 2)\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.RSADA","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.RSADA","text":"RSADA{D,S}\n\nA R-SADA monitoring statistic, whcih is used for monitoring the mean of partially-observed independent data streams. The monitoring statistic iteratively samples arms (data streams) and updates a set of local statistics based on the observed values of the data streams. The RSADA algorithm uses the local statistics to make decisions on which arms to sample at each iteration.\n\nFields\n\nk: The allowance constant of the CUSUM Control chart. Default value is 0.1.\nmu_min: The minimum value of the mean shift to detect. Default value is 0.2.\np::Int: The number of independent data streams. Default value is 1.\nq::Int: The number of data streams that are observable at each iteration. Default value is 1.\ndist::Distribution: The distribution of the data streams. Default value is Normal(0,1).\nvalue: The current value of the monitoring statistic. Default value is 0.0.\neta: The vector of augmented variables. Initialized to be a vector of zeros for each data stream.\nobs::Vector{Int}: The indices of the data streams to sample. Default value is an array of q random integers between 1 and p.\nS1::Vector{F}: The sum of the rewards for each arm.\nS2::Vector{F}: The sum of the squared rewards for each arm.\n\nReferences\n\nXian, X., Zhang, C., Bonk, S., & Liu, K. (2019). Online monitoring of big data streams: A rank-based sampling algorithm by data augmentation. Journal of Quality Technology, 53(2), 135-153. https://doi.org/10.1080/00224065.2019.1681924\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.augmented_vector!-NTuple{5, Any}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.augmented_vector!","text":"augmented_vector(y, obs, mu, dist)\n\nCompute the augmented vector eta (Equation 10 of [Xian et Al., 2019]) based on the given parameters.\n\nArguments\n\ny: The input vector.\nobs: The indices of the observed elements in y.\nmu: The mean parameter.\ndist: The IC distribution of the individual data streams.\n\nReturns\n\neta: The computed augmented vector.\n\nReferences\n\nXian, X., Zhang, C., Bonk, S., & Liu, K. (2019). Online monitoring of big data streams: A rank-based sampling algorithm by data augmentation. Journal of Quality Technology, 53(2), 135-153. https://doi.org/10.1080/00224065.2019.1681924\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.update_sampling!-Tuple{RSADA}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.update_sampling!","text":"update_sampling!(STAT::RSADA)\n\nUpdate the monitored data streams of the RSADA monitoring statistic STAT by selecting the top-q values of the local monitoring statistics in STAT.S1.\n\nArguments\n\nSTAT: The RSADA object to update.\n\nReturns\n\nSTAT.obs: The selected indices of the top STAT.q values of STAT.S1.\n\n\n\n\n\n","category":"method"},{"location":"statistics.html#StatisticalProcessMonitoring.TRAS","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.TRAS","text":"TRAS{F,D}\n\nFields\n\nA Top-r-based Adaptive Sampling monitoring statistic for monitoring multiple data streams with partial observations.\n\nFields\n\nk::Float64: The allowance constant for the CUSUM statistic. Defaults to 0.1.\nmu_min::Float64: The minimum shift to be detected. Defaults to 1.0.\nvalue::Float64: The current value of the monitoring statistic. Defaults to 0.0.\nΔ::Float64: The compensation coefficient for non-observed variables.\nr::Int: The number of largest variables to sum.\nq::Int: The total number of observable variables.\np::Int: The total number of variables.\nW::Vector{Float64}: The vector of local monitoring statistics. Defaults to a vector of zeros.\nW1::Vector{Float64}: The vector used to store the local monitoring statistics to detect increases in the mean. Defaults to a vector of zeros.\nW2::Vector{Float64}: The vector used to store the local monitoring statistics to detect decreases in the mean. Defaults to a vector of zeros.\nobs::Vector{Int}: The selected indices of the top q values of local monitoring statistics. Defaults to a random sample of size q from the range 1:p.\nsampler::S: The sampling strategy used to select the next set of obs indices. Defaults to ThompsonSampling().\n\nReferences\n\nLiu, K., Mei, Y., & Shi, J. (2015). An Adaptive Sampling Strategy for Online High-Dimensional Process Monitoring. Technometrics, 57(3), 305-319. https://doi.org/10.1080/00401706.2014.947005\n\n\n\n\n\n","category":"type"},{"location":"statistics.html#StatisticalProcessMonitoring.update_sampling!-Tuple{TRAS}","page":"Monitoring statistics","title":"StatisticalProcessMonitoring.update_sampling!","text":"update_sampling!(STAT::TRAS)\n\nUpdate the monitored data streams of the TRAS monitoring statistic STAT using its associated AbstractSampler object.\n\nArguments\n\nSTAT: The TRAS object to update.\n\nReturns\n\nSTAT.obs: The selected indices of the top STAT.q values of STAT.S1.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#Optimization","page":"Optimization","title":"Optimization","text":"","category":"section"},{"location":"optimization.html","page":"Optimization","title":"Optimization","text":"Modules = [StatisticalProcessMonitoring]\nPages = [\"interface.jl\", \"bisectioncl.jl\", \"double-bootstrap.jl\", \"sacl.jl\", \"optsettings.jl\", \"grid-search.jl\", \"nlopt.jl\"]","category":"page"},{"location":"optimization.html#StatisticalProcessMonitoring.Phase2","page":"Optimization","title":"StatisticalProcessMonitoring.Phase2","text":"Phase2 is a struct that holds the reference sample data and a sampling method, which is used to generate new observations from the reference data. \n\nArguments\n\nsamp::AbstractSampling: The sampling method to be used to generate new observations. Defaults to Bootstrap().\ndata: The data from which observations need to be resampled.\n\nExamples\n\nx = randn(500) PH2 = Phase2(data = x)\n\n\n\n\n\n","category":"type"},{"location":"optimization.html#StatisticalProcessMonitoring.Phase2Distribution","page":"Optimization","title":"StatisticalProcessMonitoring.Phase2Distribution","text":"Phase2Distribution{T} <: AbstractPhase2\n\nA struct that is used to generate and new data from a distribution. It contains a sampleable field dist of type T, which represents the underlying data-generating process.\n\nNotes\n\nA method rand(::T) is required to generate new data from dist.\n\nExample\n\nusing Distributions\nDGP = Phase2Distribution(Normal(0,1))\nnew_data(DGP)\n\n\n\n\n\n","category":"type"},{"location":"optimization.html#StatisticalProcessMonitoring.get_design-Tuple{StatisticalProcessMonitoring.AbstractStatistic}","page":"Optimization","title":"StatisticalProcessMonitoring.get_design","text":"get_design(stat::AbstractStatistic)\n\nGet the vector of hyperparameters of a statistic.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.get_maxrl-Tuple{StatisticalProcessMonitoring.AbstractStatistic}","page":"Optimization","title":"StatisticalProcessMonitoring.get_maxrl","text":"get_maxrl(stat::AbstractStatistic)\nget_maxrl(stat::Vector{T <: AbstractStatistics})\n\nGet the maximum value of the run length for a statistic stat.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.get_value-Tuple{StatisticalProcessMonitoring.AbstractStatistic}","page":"Optimization","title":"StatisticalProcessMonitoring.get_value","text":"get_value(stat::AbstractStatistic)\n\nGet the current value of a statistic.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.new_data-Tuple{Phase2}","page":"Optimization","title":"StatisticalProcessMonitoring.new_data","text":"new_data(PH2::Phase2{S,T})\nnew_data(PH2::Phase2{S,AbstractVector})\nnew_data(PH2::Phase2{S,AbstractMatrix})\n\nGenerates a new observation using the Phase II object.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.optimize_design","page":"Optimization","title":"StatisticalProcessMonitoring.optimize_design","text":"optimize_design(CH::ControlChart, rlsim_oc::Function, settings::OptSettings=OptSettings(CH); optimizer::Symbol = :LN_BOBYQA, solver::Symbol = :SACL, nsims_opt::Int = 1000, kw...)\n\nOptimizes the design of a control chart using a specified optimization algorithm.\n\nArguments\n\nCH::ControlChart: The control chart object to optimize.\nrlsim_oc::Function: A function that simulates the out-of-control state of the control chart.\nsettings::OptSettings: The optimization settings that control the optimization routine (default: OptSettings(CH)).\n\nKeyword Arguments\n\noptimizer::Symbol: The optimization algorithm to use (default: :Grid).\nsolver::Symbol: The root-finding algorithm to use for control limit estimation (default: :Bootstrap).\nhmax::Float64: The maximum value of the control limit, used only for the bisection algorithm (default: 100.0)\nkw...: Additional keyword arguments to pass to the solver algorithm.\n\nReturns\n\nThe optimized design parameters of the control chart.\n\n\n\n\n\n","category":"function"},{"location":"optimization.html#StatisticalProcessMonitoring.optimize_design!","page":"Optimization","title":"StatisticalProcessMonitoring.optimize_design!","text":"optimize_design!(CH::ControlChart, rlsim_oc::Function, settings::OptSettings=OptSettings(CH); optimizer = :LN_BOBYQA, solver = :Bootstrap, hmax::Float64 = 20.0, kw...)\n\nOptimizes the design of a control chart CH using a specified optimization algorithm.\n\nArguments\n\nCH::ControlChart: The control chart object to optimize.\nrlsim_oc::Function: A function that simulates the out-of-control state of the control chart.\nsettings::OptSettings: The optimization settings that control the optimization routine (default: OptSettings(CH)).\n\nKeyword Arguments\n\noptimizer::Symbol: The optimization algorithm to use (default: :Grid).\nsolver::Symbol: The root-finding algorithm to use for control limit estimation (default: :Bootstrap).\nhmax::Float64: The maximum value of the control limit, used only when the solver is set to :Bisection (default: 100.0)\nkw...: Additional keyword arguments to pass to the solver algorithm.\n\nReturns\n\nThe optimized design parameters of the control chart.\n\n\n\n\n\n","category":"function"},{"location":"optimization.html#StatisticalProcessMonitoring.optimize_limit","page":"Optimization","title":"StatisticalProcessMonitoring.optimize_limit","text":"optimize_limit(CH::ControlChart, solver::Symbol = :Bootstrap; kw...)\n\nOptimizes the control limit of a ControlChart object, without modifying the original ControlChart object.\n\nArguments\n\nCH::ControlChart: The ControlChart object to optimize.\nsolver::Symbol: The solver algorithm to use (default: :Bootstrap).\n\nKeyword Arguments\n\nhmax::Float64: The maximum value of the control limit. Used only for the bisection algorithm (default: 100.0)\nkw...: Additional keyword arguments to pass to the algorithm.\n\nReturns\n\nThe optimized control limit value.\n\nRaises\n\nValueError: If the optimization method specified in settings is unknown.\n\nExample\n\noptimize_limit(my_chart, settings=OptSettings(ic_solver=:SA))\n\n\n\n\n\n","category":"function"},{"location":"optimization.html#StatisticalProcessMonitoring.optimize_limit!","page":"Optimization","title":"StatisticalProcessMonitoring.optimize_limit!","text":"optimize_limit(CH::ControlChart, solver = :Bootstrap; hmax = 20.0, kw...)\n\nOptimizes the control limit of a ControlChart object.\n\nArguments\n\nCH::ControlChart: The ControlChart object to optimize.\nsolver::Symbol: The solver algorithm to use (default: :Bootstrap).\n\nKeyword Arguments\n\nhmax::Float64: The maximum value of the control limit. Only used for the bisection algorithm (default: 100.0)\nkw...: Additional keyword arguments to pass to the algorithm.\n\nReturns\n\nThe optimized control limit value.\n\nRaises\n\nValueError: If the optimization method specified in settings is unknown.\n\n\n\n\n\n","category":"function"},{"location":"optimization.html#StatisticalProcessMonitoring.set_design!-Tuple{StatisticalProcessMonitoring.AbstractStatistic, AbstractVector}","page":"Optimization","title":"StatisticalProcessMonitoring.set_design!","text":"set_design!(stat::AbstractStatistic, par::AbstractVector)\n\nSet the vector of hyperparameters of a statistic.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.set_value!-Tuple{StatisticalProcessMonitoring.AbstractStatistic, Any}","page":"Optimization","title":"StatisticalProcessMonitoring.set_value!","text":"function set_value!(stat::AbstractStatistic, value)\n\nSet the value of a statistic.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.update_statistic!-Tuple{StatisticalProcessMonitoring.AbstractStatistic, Any}","page":"Optimization","title":"StatisticalProcessMonitoring.update_statistic!","text":"update_statistic!(stat::AbstractStatistic, x)\n\nUpdate a statistic with a new observation x\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.bisectionCL!-Tuple{ControlChart, Any}","page":"Optimization","title":"StatisticalProcessMonitoring.bisectionCL!","text":"bisectionCL!(CH::ControlChart, hmax[; rlsim::Function, kw...])\n\nComputes the control limit to satisfy the nominal properties of a control chart, using the bisection algorithm (see for instance Qiu, 2013)\n\nArguments\n\nCH - A control chart.\nhmax - The maximum value for the control limit.\n\nKeyword arguments\n\nrlsim - A function that generates a run length for the control chart with signature rlsim(CH; maxiter). If left unspecified, defaults to run_sim. See the help for run_sim for more information about the signature of the function.\nnsims - The number of run lengths used to estimate the target nominal property (default: 10000).\nhmin - The minimum value of the control limit, (default: sqrt(eps())).\nmaxiter - The maximum number of bisection iterations (default: 30).\nmaxrl - The value at which to maxrlate the run length, to avoid excessive computations (default: Inf, i.e. no maxrlation).\nx_tol - Absolute tolerance for the algorithm, which is terminated if   h^(k+1) - h^(k)  x_texttol   (default: 1e-06)\nf_tol - Absolute tolerance for the algorithm, which is terminated if   texttarget(h^(k+1)) - texttarget(h^(k))  f_texttol   (default: 1.0)\nverbose - Whether to print information to the user about the state of the optimization (default: false).\nparallel::Bool - Whether the algorithm should be run in parallel, using available threads (default: false)\n\nReturns\n\nA NamedTuple containing the estimated control limit h, the total number of iterations iter, and information status about the convergence of the algorithm.\n\nReferences\n\nQiu, P. (2013). Introduction to Statistical Process Control. Boca Raton: CRC Press.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.bisectionCL-Tuple{ControlChart, Any}","page":"Optimization","title":"StatisticalProcessMonitoring.bisectionCL","text":"bisectionCL(CH::ControlChart, hmax; kw...)\n\nApplies the bisection algorithm to find the control limit of a control chart without modifying the control chart object CH.\n\nKeyword arguments\n\nSee the documentation of bisectionCL! for more information about the algorithm and keyword arguments.\n\nReturns\n\nA NamedTuple containing the estimated control limit h, the total number of iterations iter, and information status about the convergence of the algorithm.\n\nReferences\n\nQiu, P. (2013). Introduction to Statistical Process Control. Boca Raton: CRC Press.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.combinedCL!-Tuple{ControlChart}","page":"Optimization","title":"StatisticalProcessMonitoring.combinedCL!","text":"combinedCL!(CH::ControlChart[; rlsim::Function, kw...])\n\nComputes the control limit to satisfy the nominal properties of a control chart, using the bisection algorithm (see for instance Qiu, 2013). The control limit upper bound hmax for the bisection algorithm is found using the stochastic approximation algorithm of Capizzi and Masarotto (2016)\n\nArguments\n\nCH - A control chart.\n\nKeyword arguments\n\ninflate::Real - An inflation constant for the starting control limit value so that, on average, the first iteration will move the control limit to lower values. This usually saves computational time (default: 1.05).\nparallel::Bool - Whether the algorithm should be run in parallel, using available threads (default: false)\n\nBisection algorithm\n\nrlsim - A function that generates a run length for the control chart with signature rlsim(CH; maxiter). If left unspecified, defaults to run_sim. See the help for run_sim for more information about the signature of the function.\nnsims - The number of run lengths used to estimate the target nominal property (default: 10000).\nhmin - The minimum value of the control limit, (default: sqrt(eps())).\nmaxiter - The maximum number of bisection iterations (default: 30).\nmaxrl - The value at which to maxrlate the run length, to avoid excessive computations (default: Inf, i.e. no maxrlation).\nx_tol - Absolute tolerance for the algorithm, which is terminated if   h^(k+1) - h^(k)  x_texttol   (default: 1e-06)\nf_tol - Absolute tolerance for the algorithm, which is terminated if   texttarget(h^(k+1)) - texttarget(h^(k))  f_texttol   (default: 1.0)\n\nSA algorithm\n\nNfixed - The number of iterations for the gain estimation stage (default: 200).\nAfixed - The fixed gain during the gain estimation stage (default: 0.1).\nAmin - The minimum allowed value of gain (default: 0.1).\nAmax - The maximum allowed value of gain (default: 100).\ndeltaSA - The shift in control limit used during the gain estimation stage (default: 0.1).\nq - The power that controls the denominator in the Robbins-Monro algorithm (default: 0.55).\ngamma - The precision parameter for the stopping criterion of the algorithm (default: 0.05).\nNmin - The minimum number of iterations required for the algorithm to end (default: 200).\nz - The quantile of the Normal(0,1) that controls the probability of the stopping criterion being satisfied (default: 3.0).\nCmrl - The inflation factor for the maximum number of iterations the run length may run for (default: 10.0).\nmaxiter_sa - Maximum number of iterations before the algorithm is forcibly ended (default: 200).\nverbose - Whether to print information to the user about the state of the optimization (default: false).\n\nReturns\n\nA NamedTuple containing the estimated control limit h, the total number of iterations iter, and information status about the convergence of the algorithm.\n\nReferences\n\nQiu, P. (2013). Introduction to Statistical Process Control. Boca Raton: CRC Press.\nCapizzi, G., & Masarotto, G. (2016). Efficient control chart calibration by simulated stochastic approximation. IIE Transactions, 48(1), 57-65. https://doi.org/10.1080/0740817X.2015.1055392\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.combinedCL-Tuple{ControlChart}","page":"Optimization","title":"StatisticalProcessMonitoring.combinedCL","text":"combinedCL(CH::ControlChart; kw...)\n\nApplies the bisection algorithm to find the control limit of a control chart without modifying the control chart object CH. The control limit upper bound hmax for the bisection algorithm is found using the stochastic approximation algorithm of Capizzi and Masarotto (2016). See the documentation of combinedCL! for more information about the algorithm and keyword arguments.\n\nKeyword arguments\n\nSee the documentation of combinedCL! for a list of keyword arguments.\n\nReturns\n\nA NamedTuple containing the estimated control limit h, the total number of iterations iter, and information status about the convergence of the algorithm.\n\nReferences\n\nQiu, P. (2013). Introduction to Statistical Process Control. Boca Raton: CRC Press.\nCapizzi, G., & Masarotto, G. (2016). Efficient control chart calibration by simulated stochastic approximation. IIE Transactions, 48(1), 57-65. https://doi.org/10.1080/0740817X.2015.1055392\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.bootstrapCL!-Tuple{ControlChart}","page":"Optimization","title":"StatisticalProcessMonitoring.bootstrapCL!","text":"bootstrapCL!(CH::ControlChart[; rlsim::Function, kw...])\n\nComputes the control limit to satisfy the nominal properties of a control chart, using the bisection algorithm on bootstrapped paths (see for instance Qiu, 2013).\n\nArguments\n\nCH - A control chart.\n\nKeyword arguments\n\nrlsim - A function that generates a path of the control chart statistic with signature rlsim(CH; maxiter). If left unspecified, defaults to run_path_sim. See the help for run_path_sim for more information about the signature of the function.\nsettings - An OptSettings objects which contains variables that control the behaviour of the algorithm. See the Accepted settings section below for information about the settings that control the behaviour of the algorithm. For more information about the specifics of each keyword argument, see for instance Qiu (2013).\nmaxiter - The maximum number of bisection iterations.\nnsims - The number of run lengths used to estimate the target nominal property.\nmaxrl - The maximum run length after which the run length is truncated, to avoid excessive computations.\nx_tol - Absolute tolerance for the algorithm, which is ended if   h^(k+1) - h^(k)  x_texttol\nf_tol - Absolute tolerance for the algorithm, which is ended if   texttarget(h^(k+1)) - texttarget(h^(k))  f_texttol\n\nReturns\n\nA NamedTuple containing the estimated control limit h, the total number of iterations iter, and information status about the convergence of the algorithm.\n\nReferences\n\nQiu, P. (2013). Introduction to Statistical Process Control. Boca Raton: CRC Press.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.bootstrapCL-Tuple{ControlChart}","page":"Optimization","title":"StatisticalProcessMonitoring.bootstrapCL","text":"bootstrapCL(CH::ControlChart; kw...)\n\nApplies the bisection algorithm on simulated run length paths to find the control limit of a control chart without modifying the control chart object CH.\n\nKeyword arguments\n\nSee the documentation of bootstrapCL! for more information about the algorithm and keyword arguments.\n\nReturns\n\nA NamedTuple containing the estimated control limit h, the total number of iterations iter, and information status about the convergence of the algorithm.\n\nReferences\n\nQiu, P. (2013). Introduction to Statistical Process Control. Boca Raton: CRC Press.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.calculate_limit_gradient-Tuple{StatisticalProcessMonitoring.AbstractChart, Any}","page":"Optimization","title":"StatisticalProcessMonitoring.calculate_limit_gradient","text":"calculate_limit_gradient(CH::AbstractChart, rl::Real)\ncalculate_limit_gradient(nominal::ARL, rl)\ncalculate_limit_gradient(nominal::QRL, rl)\n\nCalculate the gradient for the optimization of the control limit.\n\nIf the control chart nominal attribute is of type ARL, then the gradient is calculated according to Equation (9) of Capizzi and Masarotto (2016).\n\nIf the control chart nominal attribute is of type QRL, then the gradient is calculated using the recursion on page 280 of Capizzi and Masarotto (2009)\n\nReferences\n\nCapizzi, G., & Masarotto, G. (2016). \"Efficient Control Chart Calibration by Simulated Stochastic Approximation\". IIE Transactions 48 (1). https://doi.org/10.1080/0740817X.2015.1055392.\n\nCapizzi, G. & Masarotto, G. (2009) Bootstrap-based design of residual control charts, IIE Transactions, 41:4, 275-286, DOI: https://doi.org/10.1080/07408170802120059 \n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.saCL!-Tuple{ControlChart}","page":"Optimization","title":"StatisticalProcessMonitoring.saCL!","text":"saCL!(CH::ControlChart[; rlsim::Function, kw...])\n\nComputes the control limit to satisfy the nominal properties of a control chart, using the stochastic approximation algorithm described in Capizzi and Masarotto (2016).\n\nArguments\n\nCH - A control chart.\n\nKeyword arguments\n\nrlsim - A function that generates new data with signature rlsim(CH; maxiter, delta). If left unspecified, defaults to run_sim_sa. See the help for run_sim_sa for more information about the requirements of the function.\nsettings - An OptSettings objects which contains variables that control the behaviour of the algorithm. See the Accepted settings section below for information about the settings that control the behaviour of the algorithm. For more information about the specifics of each keyword argument, see Capizzi and Masarotto (2016).\nNfixed - The number of iterations for the gain estimation stage (default: 500).\nAfixed - The fixed gain during the gain estimation stage (default: 0.1).\nAmin - The minimum allowed value of gain (default: 0.1).\nAmax - The maximum allowed value of gain (default: 100.0).\ndelta_sa - The shift in control limit used during the gain estimation stage (default: 0.1).\nq - The power that controls the denominator in the Robbins-Monro algorithm (default: 0.55).\ngamma - The precision parameter for the stopping criterion of the algorithm (default: 0.02).\nNmin - The minimum number of iterations to avoid early terminations (default: 1000).\nz - The quantile of the Normal(0,1) that controls the probability of the stopping criterion being satisfied (default: 3.0).\nCmrl - The inflation factor for the maximum number of iterations the run length may run for (default: 10.0).\nmaxiter - Maximum number of iterations before the algorithm is forcibly ended (default: 50000).\nverbose - Whether to print information to the user about the state of the optimization (default: false).\nparallel::Bool - Whether the algorithm should be run in parallel, using available threads (default: false). Parallelization is achieved by averaging Threads.nthreads independent replications of the algorithm, each with precision parameter gamma*sqrt(Threads.nthreads). See [Capizzi, 2016] for further discussion on parallelizing the SA algorithm.\n\nReturns\n\nA NamedTuple containing the estimated control limit h, the total number of iterations iter, and information status about the convergence of the algorithm.\n\nReferences\n\nCapizzi, G., & Masarotto, G. (2016). \"Efficient Control Chart Calibration by Simulated Stochastic Approximation\". IIE Transactions 48 (1). https://doi.org/10.1080/0740817X.2015.1055392.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.saCL-Tuple{ControlChart}","page":"Optimization","title":"StatisticalProcessMonitoring.saCL","text":"saCL(CH::ControlChart[; rlsim::Function, kw...])\n\nApplies the stochastic approximation algorithm of Capizzi and Masarotto (2016) without modifying the control chart object CH.\n\nKeyword arguments\n\nSee the documentation of saCL! for more information about the algorithm and the keyword arguments.\n\nReturns\n\nA NamedTuple containing the estimated control limit h, the total number of iterations iter, and information status about the convergence of the algorithm.\n\nReferences\n\nCapizzi, G., & Masarotto, G. (2016). \"Efficient Control Chart Calibration by Simulated Stochastic Approximation\". IIE Transactions 48 (1). https://doi.org/10.1080/0740817X.2015.1055392.\n\n\n\n\n\n","category":"method"},{"location":"optimization.html#StatisticalProcessMonitoring.optimize_grid-Tuple{ControlChart, Function, OptSettings}","page":"Optimization","title":"StatisticalProcessMonitoring.optimize_grid","text":"optimize_grid(CH::ControlChart, rlconstr::Function, settings::OptSettings)\n\nOptimizes a control chart by finding the best set of parameters using a grid search.\n\nArguments\n\nCH::ControlChart: The control chart object whose parameters must be optimized.\nrlconstr::Functiom: The function that evaluates the OC performance of the control chart.\nsettings::OptSettings: The optimization settings.\n\nReturns\n\npar_current (Vector{Float64}): the optimal set of parameters found by the optimization algorithm.\n\nReferences\n\nQiu, P. (2008). Distribution-Free Multivariate Process Control Based on Log-Linear Modeling. IIE Transactions, 40(7), 664-677. https://doi.org/10.1080/07408170701744843\n\n\n\n\n\n","category":"method"},{"location":"monitoring_risk_adjusted.html#Monitoring-Surgical-Outcomes-Using-a-Risk-Adjusted-CUSUM-Chart","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"","category":"section"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"In this example, we demonstrate the use of a risk-adjusted CUSUM chart. The data comes from a center for cardiac surgery in the UK and is available in the cardiacsurgery.csv file at this Zenodo link.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"First, the required packages are loaded","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"using StatisticalProcessMonitoring, Distributions, Random, Parameters, CSV, DataFrames, CategoricalArrays, MixedModels, Plots","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"The dataset is then loaded as a DataFrame and the surgeon variable is categorized.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> dat = CSV.read(\"cardiacsurgery.csv\", DataFrame)\njulia> dat.surgeon = categorical(dat.surgeon)","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"We divide the data into Phase I (first two years) for model estimation and Phase II (following year) for prospective monitoring.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> dat_ic = dat[dat.date .<= 730, :]","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"We estimate the post-operative mortality rate on the Phase I data using a logistic regression model with the Parsonnet score as a covariate and the surgeon as a random intercept.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> using MixedModels\njulia> mod = fit(MixedModel, @formula(status ~ Parsonnet + (1|surgeon)),\n                 dat_ic, Bernoulli())\njulia> print(mod)\nGeneralized Linear Mixed Model fit by maximum likelihood (nAGQ = 1)\n  status ~ 1 + Parsonnet + (1 | surgeon)\n  Distribution: Bernoulli{Float64}\n  Link: LogitLink()\n\n   logLik    deviance     AIC       AICc        BIC    \n  -388.8235   777.6471   783.6471   783.6607   800.0816\n\nVariance components:\n           Column   Variance Std.Dev. \nsurgeon (Intercept)  0.037837 0.194518\n\n Number of obs: 1769; levels of grouping factors: 6\n\nFixed-effects parameters:\n─────────────────────────────────────────────────────\n                  Coef.  Std. Error       z  Pr(>|z|)\n─────────────────────────────────────────────────────\n(Intercept)  -3.65655    0.17509     -20.88    <1e-96\nParsonnet     0.0818093  0.00723527   11.31    <1e-28\n─────────────────────────────────────────────────────","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"For Phase II monitoring, we consider data from the following year.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> dat_oc = dat[730 .< dat.date .<= 1095, :]","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"We use a risk-adjusted CUSUM control chart to monitor potential increases in post-operative patient mortality.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> Random.seed!(239184367)\njulia> STAT = RiskAdjustedCUSUM(Δ = 0.75, model = mod, response = :status)","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"We set the IC average run length to 1000 and initialize the control limit.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> NOM = ARL(1000)\njulia> LIM = OneSidedFixedLimit(1.0, true)","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"In-control run lengths for estimating the control limit are simulated by resampling the Phase I data using bootstrap.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> PH2 = Phase2(Bootstrap(), dat_ic)","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"After creating the ControlChart object, we find the control limit using stochastic approximations.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> CH = ControlChart(STAT, LIM, NOM, PH2)\njulia> h = saCL!(CH, verbose = true, gamma = 0.05)\nRunning SA ...\nRunning adaptive gain ...\nEstimated gain D = 0.4117860274331409\nRunning optimization ...\ni: 0/50000      h: 2.77856      hm: 0.0 stop: 0\ni: 1000/50000   h: 2.86375      hm: 2.9541      stop: 3457\ni: 2000/50000   h: 2.94813      hm: 2.95045     stop: 3435\ni: 3000/50000   h: 2.92253      hm: 2.95877     stop: 3420\ni: 3359/50000   Convergence!\n(h = 2.9568877844997226, iter = 3359, status = \"Convergence\")","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"We apply the control chart to the Phase II data and plot the results of the monitoring.","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"julia> proc = apply_chart(CH, dat_oc)\njulia> plt = plot_series(proc, dpi = 300, label = \"\", xlab = L\"t\",\n                         ylab = L\"C_t\")","category":"page"},{"location":"monitoring_risk_adjusted.html","page":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","title":"Monitoring Surgical Outcomes Using a Risk-Adjusted CUSUM Chart","text":"(Image: )","category":"page"},{"location":"using_control_charts.html#Setting-up-a-control-chart","page":"Setting up a control chart","title":"Setting up a control chart","text":"","category":"section"},{"location":"getting-started.html#Getting-started","page":"Getting started","title":"Getting started","text":"","category":"section"},{"location":"getting-started.html#Type-hierarchy","page":"Getting started","title":"Type hierarchy","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"The StatisticalProcessMonitoring.jl package introduces a flexible definition of a control chart through the ControlChart type. The attributes of ControlChart determine its main properties.","category":"page"},{"location":"getting-started.html#ControlChart-type","page":"Getting started","title":"ControlChart type","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"mutable struct ControlChart{STAT, LIM, NOM, PH2} <: AbstractChart{STAT, LIM, NOM, PH2}\n  stat::STAT\n  limit::LIM\n  nominal::NOM\n  phase2::PH2\n  t::Int\nend","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Attributes:\nstat: Monitoring statistic (see Monitoring statistics).\nlimit: Control limit (see Control limits).\nnominal: Nominal property (see Section Nominal properties).\nphase2: Phase II data simulator (see Simulating new observations).\nt: Current time point indicator.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"This type is defined as mutable, allowing updates via functions such as update_chart!.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"function update_chart!(CH::AbstractChart, x)\n  CH.t += 1\n  update_statistic!(get_statistic(CH), x)\nend","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Then, a suitable implementation of update_statistic! will produce the desired behaviour of the monitoring statistic.","category":"page"},{"location":"getting-started.html#Example:-EWMA-and-AEWMA-statistics","page":"Getting started","title":"Example: EWMA and AEWMA statistics","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"To demonstrate the flexibility of the interface, consider the EWMA and AEWMA control charts that share control limits, nominal property, and phase II data, differing only in their statistics.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"mutable struct EWMA <: AbstractStatistic \n  λ::Float64\n  value::Float64\nend","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"mutable struct AEWMA <: AbstractStatistic \n  λ::Float64\n  k::Float64\n  value::Float64\nend","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"The update_statistic! function is specialized for each statistic:","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"function update_statistic!(stat::EWMA, x::Real)\n  stat.value = (1.0 - stat.λ) * stat.value + stat.λ * x\nend\n\nfunction update_statistic!(stat::AEWMA, x::Real)\n  stat.value = stat.value + huber(x - stat.value, stat.λ, stat.k)\nend","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Here, the huber function implements Huber's score function. Then, as an example, we can define two control charts as:","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"CH_E  = ControlChart(EWMA(λ = 0.2),\n                     TwoSidedFixedLimit(0.25),\n                     ARL(200),\n                     Phase2Distribution(Normal(0,1)\n                     )\n\nCH_AE = ControlChart(AEWMA(λ = 0.2, k=3.0),\n                     TwoSidedFixedLimit(0.25),\n                     ARL(200),\n                     Phase2Distribution(Normal(0,1)\n                     )","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"The two charts are defined with the same control limit, nominal properties, and Phase 2 object. However, their behaviour will be that of the EWMA and AEWMA control charts, respectively.","category":"page"},{"location":"getting-started.html#Implementation-of-multi-chart-monitoring-schemes","page":"Getting started","title":"Implementation of multi-chart monitoring schemes","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Multi-chart monitoring is supported by the MultipleControlChart type alias.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"const MultipleControlChart{S,L,N,P} = ControlChart{S,L,N,P} where {S<:Tuple,L<:Tuple,N,P}","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"For example, a multi-chart statistic composed of two EWMA charts run simultaneously for monitoring normal data can be defined as","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"ControlChart(\n    (EWMA(λ = 0.05), EWMA(λ=0.2)),\n    (TwoSidedFixedLimit(0.25), TwoSidedFixedLimit(0.5)),\n    ARL(200),\n    Phase2Distribution(Normal(0,1))\n    )","category":"page"},{"location":"getting-started.html#Control-limits","page":"Getting started","title":"Control limits","text":"","category":"section"},{"location":"getting-started.html#Types-of-control-limits","page":"Getting started","title":"Types of control limits","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Control limits (textLCL_t textUCL_t) can be fixed or dynamic (time-varying).","category":"page"},{"location":"getting-started.html#Fixed-control-limits","page":"Getting started","title":"Fixed control limits","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Defined using constant boundaries. For h  0,","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"textLCL_t = -h quad textUCL_t = h quad textfor all   t","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Implemented as TwoSidedFixedLimit and OneSidedFixedLimit. The OneSidedFixedLimit allows choosing limits of the form (0 h), if its upw attribute is set to true, or (-h 0) if set to false.","category":"page"},{"location":"getting-started.html#Deterministic-time-varying-control-limits","page":"Getting started","title":"Deterministic time-varying control limits","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"For example, time-varying limits for the EWMA chart with fast initial response:","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"textLCL_t = h cdot g_l(t) quad textUCL_t = h cdot g_u(t)","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Implemented as TwoSidedCurvedLimit and OneSidedCurvedLimit, which also require specification of a deterministic function g(t) .","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Alternatively, the TwoSidedBootstrapLimit and OneSidedBootstrapLimit allow defining control limits based on bootstrap resampling, which provide time-varying control limits with approximately constant false alarm rate","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"mathbbP(C_t notin (textLCL_t textUCL_t)  C_s in (textLCL_s textUCL_s)  text for all  s  t) = alpha","category":"page"},{"location":"getting-started.html#Nominal-properties","page":"Getting started","title":"Nominal properties","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Subtypes of NominalProperties, they define IC run length constraints for the control chart.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"ARL specifies the nominal average run length, mathbbE_0textRL.\nQRL specifies the nominal p-level quantile of the IC run length.","category":"page"},{"location":"getting-started.html#Simulating-new-observations","page":"Getting started","title":"Simulating new observations","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Implemented in subtypes of AbstractPhase2.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Phase2Distribution samples data from distributions using the Distributions.jl package.\nPhase2 resamples from an IC reference dataset (either a vector, a matrix or a data frame), supporting techniques like bootstrap.","category":"page"},{"location":"getting-started.html#Monitoring-statistics","page":"Getting started","title":"Monitoring statistics","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Monitoring statistics, subtyped from AbstractStatistic, implement update_statistic! to define the update behaviour as new data is sequentially observed.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Monitoring statistic Type name Hyperparameters Reference Paper\nMean (univariate)   \nShewhart Shewhart – Shewhart (1931)\nCUSUM CUSUM $ k \\in \\mathbb{R}^+ $ Page (1954)\nEWMA EWMA $ \\lambda \\in (0,1)$ Roberts (1959)\nOne-sided EWMA OneSidedEWMA $ \\lambda\\in (0,1)$ Champ et Al. (1991)\nAdaptive EWMA AEWMA $ \\lambda\\in (0,1), k\\in \\mathbb{R}^+ $ Capizzi and Masarotto (2003)\nWeighted CUSUM WCUSUM $ \\lambda \\in (0,1)$, $ k \\in \\mathbb{R}^+ $ Shu et Al. (2008)\nMean (multivariate)   \nMShewhart MShewhart – Shewhart (1931)\nMEWMA DiagMEWMA $ \\bm{\\lambda} \\in (0,1)^{p}$ Lowry et Al. (1992)\nMCUSUM MCUSUM $ k\\in \\mathbb{R}^+ $ Crosier (1988)\nAdaptive MEWMA MAEWMA $ \\lambda\\in (0,1)$, $ k \\in \\mathbb{R}^+ $ Mahmoud and Zahran (2010)\nAdaptive MCUSUM AMCUSUM $ \\lambda\\in (0,1)$ Dai et Al. (2011)\nLLCUSUM LLCUSUM $ k \\in \\mathbb{R}^+ $ Qiu (2008)\nLLD LLD $ \\lambda\\in (0,1)$ Li et Al. (2012)\nMOC MOC $ \\lambda\\in (0,1)$ Wang et Al. (2017)\nVariance/covariance   \nGLR-based statistic ALT – Alt (1984)\nMEWMS MEWMS $ \\lambda\\in (0,1)$ Huwang et Al. (2007)\nMEWMC MEWMC $ \\lambda\\in (0,1)$ Hawkins and Maboudou-Tchao (2008)\nPartially-observed data   \nR-SADA RSADA $ k, \\mu_\\text{min}\\in \\mathbb{R}^+ $ Xian et Al. (2019)\nTRAS TRAS $ k, \\mu_\\text{min}, \\Delta \\in \\mathbb{R}^+ $, $ r\\in {1, \\ldots,q} $ Liu et Al. (2015)\nProfile monitoring   \nNEWMA NEWMA $ \\lambda\\in (0,1)$ Zou et Al. (2008)\nRisk-adjusted CUSUM RiskAdjustedCUSUM $ \\Delta\\in \\mathbb{R} $ Steiner et Al. (2000)","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Table: List of available monitoring statistics in the StatisticalProcessMonitoring.jl package. Here, p is the number of quality variables under monitoring. For partially-observed data, q is the number of observed variables.","category":"page"},{"location":"getting-started.html#Statistics-with-estimated-parameters","page":"Getting started","title":"Statistics with estimated parameters","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Separation of monitoring statistic and parameter estimation promotes code compartmentalization, facilitated by subtypes like ResidualStatistic.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"For example, the definition of a monitoring statistic that behaves for k = 10 as","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"C_t = maxleft 0 left( fracX_t - 052 right) - k right","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"can be defined using the LocationScaleStatistic subclass of ResidualStatistic.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"STAT = LocationScaleStatistic(CUSUM(k=1.0), 0.5, 2.0)","category":"page"},{"location":"getting-started.html#Control-limit-design","page":"Getting started","title":"Control limit design","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Functions Symbol Description Single charts Multi-charts\nbisectionCL, bisectionCL! :Bisection The standard bisection algorithm Qiu (2013). Requires an initial interval to search for the control limit. ✔ \nsaCL, saCL! :SA Algorithm based on stochastic approximations. See Capizzi & Masarotto (2016) for a complete description of the tuning parameters. ✔ ✔\ncombinedCL, combinedCL! :Combined The standard bisection algorithm combined with a preliminary low-accuracy application of the SA algorithm to automatically select the initial interval. ✔ \nbootstrapCL, bootstrapCL! :Bootstrap Approximates the distribution of the monitoring statistic at each time t = 1 2  T for T  0, and then applies bisection search. Does not require an initial interval to begin the search. ✔ ✔","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Table: List of available algorithms for designing fixed and deterministic time-varying control limits in StatisticalProcessMonitoring.jl.","category":"page"},{"location":"getting-started.html#Bisection-search","page":"Getting started","title":"Bisection search","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"A common method for determining control limits such that the nominal run length characteristic (e.g. ARL or QRL) equals the nominal value. Starting from an interval 0 h_textmax, the method finds the appropriate control limit value via bisection, by approximating the run length characteristic at each iteration with a large number of simulated run lengths from the Phase 2 chart attribute.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"This algorithm is implemented in the bisectionCL! and bisectionCL functions.","category":"page"},{"location":"getting-started.html#Stochastic-approximations","page":"Getting started","title":"Stochastic approximations","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"For single- and multi-chart schemes, the method simulates one run length at a time and applies a stochastic gradient descent algorithm,","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"bmh_k+1 = Psileft( bmh_k - frac1(k+1)^q D bms(bmh_k) right)","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"which converges to the required control limit value.  This algorithm is implemented in the saCL! and saCL functions.","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"using Distributions, Random\nRandom.seed!(12345)\n\nchart = ControlChart(\n    (CUSUM(k = 0.25), CUSUM(k=0.5)),\n    (OneSidedFixedLimit(5.0, true), OneSidedFixedLimit(5.0, true)),\n    ARL(370),\n    Phase2Distribution(Normal(0,1))\n    )\n  \nsaCL(chart)\n(h = [7.290634106470891, 4.403721760449869], iter = 32847, status = \"Convergence\")","category":"page"},{"location":"getting-started.html#Hyperparameter-tuning","page":"Getting started","title":"Hyperparameter tuning","text":"","category":"section"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Hyperparameter tuning for optimal performance with respect to a specific out-of-control scenario is implemented via:","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"Grid search (slow for multidimensional parameters)\nNonlinear numerical solvers available from the NLopt.jl package (e.g., BOBYQA)","category":"page"},{"location":"getting-started.html","page":"Getting started","title":"Getting started","text":"The function optimize_design! provides a high-level interface for optimization and requires being able to simulate from the out-of-control scenario of interest. An example of hyperparameter optimization can be found in the Residual-Based Monitoring of Autocorrelated Data tutorial.","category":"page"},{"location":"monitoring_nonparametric_profiles.html#Detecting-Changes-in-Profiles","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"","category":"section"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"Here, we demonstrate how the Phase2 type can be used to also work with structured data types. In this example, we consider monitoring profiles: $   Y = f_{tj} = f(x_{tj}) + \\varepsilon_{ij}, \\quad j = 1, 2, \\ldots, n_t, $ where f(x_tj) is the unknown function relating x_tj to Y_tj, varepsilon_ij sim F_varepsilon, mathbbEvarepsilon_ij = 0, and mathbbVvarepsilon_ij = sigma  0 for all t and j.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"Let's load the required packages,","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"using StatisticalProcessMonitoring, Distributions, Random, Loess, Plots, LaTeXStrings","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"For simplicity, we assume equi-spaced bmx_t in [0.5, 10] with increments of 0.5 for all t = -m+1 ldots 0 1 2 ldots.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> n = 500\njulia> nj = 20\njulia> x_grid = collect(0.5:0.5:10)\njulia> xs = Matrix{Float64}(undef, n, nj)\njulia> for i in 1:n; xs[i, :] = x_grid; end","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"We generate an initial sample of 500 IC profiles from the functional process using the standard normal distribution for F_varepsilon.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> Random.seed!(41289355)\njulia> ys = sin.(xs) .+ randn(n, nj)","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"We use the FunctionalObservation type to represent profile data. The package provides an alias for representing functional data as a collection of functional observations.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"const FunctionalData{A,B} = Vector{FunctionalObservation{A,B}} where {A,B}","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"We create a Phase II object for simulating run lengths for a functional control chart.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> dat = FunctionalData(xs, ys)\njulia> PH2 = Phase2(Bootstrap(), dat)","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"We use the nonparametric exponentially weighted moving average (NEWMA) control chart. The IC profile widehatf is estimated using the LOESS estimator.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> using Loess\njulia> g = loess(vec(xs), vec(ys), span = 0.3)\njulia> plt = plot(minimum(xs):0.01:maximum(xs), (x) -> predict(g, x),\n                  linewidth = 1.75, label = L\"\\hat{f}(x)\", xlab = L\"x\", ylab = L\"y\",\n                  dpi = 300)\njulia> scatter!(plt, vec(xs), vec(ys), markersize = 1, label = \"\",\n                colour = \"black\")","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"(Image: )","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"We define a NEWMA chart with smoothing parameter lambda = 02.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> STAT = NEWMA(0.2, g, dat)","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"We use an upper decision interval with constant false-alarm rate and sequential estimation using 1000 bootstrap simulations.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> LIM = OneSidedBootstrapLimit(STAT, true, 1000)","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"We set the nominal in-control average run length to 500.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> NM = ARL(500)\njulia> CH = ControlChart(STAT, LIM, NM, PH2)","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"The NEWMA control chart is then applied to three sequences of Phase II data:","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> n2 = 150\njulia> xs_oc = xs[1:n2, :]\njulia> ys_ic = sin.(xs_oc) .+ randn(n2, nj)                  # In-control\njulia> ys_oc = sin.(xs_oc) + 2*cos.(xs_oc) .+ randn(n2, nj)  # Profile shift\njulia> ys_oc2 = sin.(xs_oc) .+ 2*randn(n2, nj)               # Variance shift","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"The matrices containing the Phase II observations are converted to FunctionalData objects, which enables application of the control chart.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> dat_ic = FunctionalData(xs_oc, ys_ic)\njulia> dat_oc = FunctionalData(xs_oc, ys_oc)\njulia> dat_oc2 = FunctionalData(xs_oc, ys_oc2)","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"Once the FunctionalData objects are created, the control chart can be run on the three data sequences.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"julia> proc_ic = apply_chart(CH, dat_ic)\njulia> proc_oc = apply_chart(CH, dat_oc)\njulia> proc_oc2 = apply_chart(CH, dat_oc2)","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"The results of applying the NEWMA control chart to the Phase II sequences are shown in Figure 1. The plots display the values of the NEWMA control chart for the three cases, with the control limits estimated and shown as a black dashed line. The control chart effectively detects changes in both the profile shift and variance shift. When the process is in control (IC), no change is detected by the control chart.","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"markersize = 1.5\nplt1 = plot_series(proc_ic, marker = :d, title = \"In-control\", l_linestyle = :dot,\n                    markersize = markersize, dpi = 300, label = \"\", xlab = L\"t\", ylab = L\"C_t\")\nplt2 = plot_series(proc_oc, marker = :o, title = \"Profile shift\",l_linestyle = :dot,\n                    markersize = markersize, dpi = 300, colour = palette(:tab10)[2],\n                    label = \"\", xlab = L\"t\", ylab = L\"C_t\")\nplt3 = plot_series(proc_oc2, marker = :square, title = \"Variance shift\", l_linestyle = :dot,\n                    markersize = markersize, dpi = 300, colour = palette(:tab10)[3],\n                    label = \"\", xlab = L\"t\", ylab = L\"C_t\")\nl = @layout [grid(1,2); _{0.2w} c{0.55w} _{0.25w}]\nplt = plot(plt1,plt2,plot(frame = :none), plt3; layout = l)","category":"page"},{"location":"monitoring_nonparametric_profiles.html","page":"Detecting Changes in Profiles","title":"Detecting Changes in Profiles","text":"(Image: )","category":"page"},{"location":"nominal_properties.html#Nominal-properties","page":"Nominal properties","title":"Nominal properties","text":"","category":"section"},{"location":"nominal_properties.html","page":"Nominal properties","title":"Nominal properties","text":"Modules = [StatisticalProcessMonitoring]\nPages = [\"nominal-interface.jl\"]","category":"page"},{"location":"nominal_properties.html#StatisticalProcessMonitoring.ARL","page":"Nominal properties","title":"StatisticalProcessMonitoring.ARL","text":"ARL(value)\n\nValue of the in-control average run length of the control chart, i.e. if RL = inft  0 textChart detects OC is the run length, then the average run length ARL is\n\nARL = mathbbERLtau = +infty,\n\nwhere tau = +infty represents the process being in-control.\n\nArguments\n\nvalue::Float64: The nominal value of the average run length. Must be greater than 1.\n\n\n\n\n\n","category":"type"},{"location":"nominal_properties.html#StatisticalProcessMonitoring.QRL","page":"Nominal properties","title":"StatisticalProcessMonitoring.QRL","text":"QRL(value, qtl)\n\nValue of the in-control quantile of the run length of the control chart, i.e. if RL = inft  0  textChart detects OC is the run length, then value is the value of the qtl-level quantile of the distribution of RL if the process is in-control.\n\nArguments\n\nvalue::Float64: The nominal value of the run length quantile.\nqtl::Float64: The level of the quantile, must be between 0 and 1. Default is 0.5.\n\n\n\n\n\n","category":"type"},{"location":"control_limits.html#Control-limits","page":"Control limits","title":"Control limits","text":"","category":"section"},{"location":"control_limits.html","page":"Control limits","title":"Control limits","text":"Modules = [StatisticalProcessMonitoring]\nPages = [\"limits-interface.jl\", \"fixed.jl\", \"dynamic.jl\"]","category":"page"},{"location":"control_limits.html#StatisticalProcessMonitoring.OneSidedFixedLimit","page":"Control limits","title":"StatisticalProcessMonitoring.OneSidedFixedLimit","text":"OneSidedFixedLimit(h::Float64, upw::Bool)\n\nClassical fixed one-sided limit, such that the run length RL of a control chart is the first time t in which the statistic C_t crosses the limit.\n\nif upw == true, RL = inft  C_t  h\nif upw == false, RL = inft  C_t  -h\n\nNote that by definition, h > 0.\n\n\n\n\n\n","category":"type"},{"location":"control_limits.html#StatisticalProcessMonitoring.TwoSidedFixedLimit","page":"Control limits","title":"StatisticalProcessMonitoring.TwoSidedFixedLimit","text":"TwoSidedFixedLimit(h::Float64)\n\nClassical fixed two-sided limit, such that the run length RL of a control chart is the first time t in which the statistic C_t crosses the limit:\n\nRL = inft  0  C_t  h.\n\nNote that by definition, h > 0.\n\n\n\n\n\n","category":"type"},{"location":"control_limits.html#StatisticalProcessMonitoring.OneSidedBootstrapLimit","page":"Control limits","title":"StatisticalProcessMonitoring.OneSidedBootstrapLimit","text":"OneSidedBootstrapLimit{T} <: BootstrapLimit{T}\n\nA one-sided bootstrap limit with constant false-alarm rate.\n\nFields\n\nsim::Vector{T}: The vector of simulated statistics.\nh::T: The current value of the control limit.\nupw::Bool: Whether the control limit is an upper or lower control limit.\n\nConstructors\n\nOneSidedBootstrapLimit(S::AbstractStatistic, upw, B::Int): Create a new OneSidedBootstrapLimit object. The argument S is an AbstractStatistic object. The argument upw determines whether the bootstrap is one-sided and upper-tailed or lower-tailed. The argument B is an integer indicating the number of bootstrap replications.\n\n\n\n\n\n","category":"type"},{"location":"control_limits.html#StatisticalProcessMonitoring.OneSidedCurvedLimit","page":"Control limits","title":"StatisticalProcessMonitoring.OneSidedCurvedLimit","text":"OneSidedCurvedLimit(h::Float64, upw::Bool)\nOneSidedCurvedLimit(h::Vector{T}, upw::Vector{Bool})\n\nCurved one-sided limit, such that the run length RL of a control chart is the first time t in which the statistic C_t crosses the limit.\n\nif upw == true, RL = inft  C_t  hcdot f(t)\nif upw == false, RL = inft  C_t  -hcdot f(t)\n\nNote that by definition, h > 0.\n\n\n\n\n\n","category":"type"},{"location":"control_limits.html#StatisticalProcessMonitoring.TwoSidedBootstrapLimit","page":"Control limits","title":"StatisticalProcessMonitoring.TwoSidedBootstrapLimit","text":"TwoSidedBootstrapLimit{T} <: BootstrapLimit{T}\n\nA two-sided bootstrap limit with constant false-alarm rate.\n\nFields\n\nsim::Vector{T}: The vector of simulated statistics.\nh::Vector{T}: The current value of the control limits.\n\nConstructors\n\nTwoSidedBootstrapLimit(S::AbstractStatistic, B::Int): Create a new TwoSidedBootstrapLimit object. The argument S is an AbstractStatistic object. The argument B is an integer indicating the number of bootstrap replications.\n\n\n\n\n\n","category":"type"},{"location":"control_limits.html#StatisticalProcessMonitoring.TwoSidedCurvedLimit","page":"Control limits","title":"StatisticalProcessMonitoring.TwoSidedCurvedLimit","text":"TwoSidedCurvedLimit(h::Float64)\nTwoSidedCurvedLimit(h::Vector{T})\n\nCurved one-sided limit, such that the run length RL of a control chart is the first time t in which the statistic C_t crosses the limit.\n\nRL = inft  0  C_t  hcdot f(t).\n\nNote that by definition, h > 0.\n\n\n\n\n\n","category":"type"},{"location":"control_limits.html#StatisticalProcessMonitoring.update_value!-Tuple{StatisticalProcessMonitoring.BootstrapLimit, ARL}","page":"Control limits","title":"StatisticalProcessMonitoring.update_value!","text":"update_value!(L::BootstrapLimit, NM::ARL)\nupdate_value!(L::BootstrapLimit, NM::QRL)\n\nUpdate the value of the BootstrapLimit object using the nominal value obtained from the ARL or QRL object.\n\nArguments\n\nL::BootstrapLimit: The BootstrapLimit object to be updated.\nNM: The ARL or QRL object used to obtain the value for the update.\n\n\n\n\n\n","category":"method"},{"location":"monitoring_mean_covariance.html#Jointly-Monitoring-the-Mean-and-Covariance-Using-a-Multi-Chart-Scheme","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"","category":"section"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"Here, we provide an example of multiple control charts being run simultaneously. We consider sequential monitoring of the data from Example 7.7 of Introduction to Statistical Process Control.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"First, the required packages are loaded","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"using StatisticalProcessMonitoring, LinearAlgebra, Random, Distributions, CSV, DataFrames, Plots","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"In the example, three quality variables resulting from a production process are monitored for changes. Under IC conditions, the quality variables follow the N_3(bm0 Sigma_0) distribution, where","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"Sigma_0 = beginpmatrix\n    10   08  05\n    08  10  08 \n    05  08  10\n  endpmatrix","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"First, we set the seed for replicability.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> seed = 54397858713\njulia> Random.seed!(seed)","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"Then, we initialize the distribution of the observations under IC conditions.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> μ = [0, 0, 0]\njulia> Σ = [1.0 0.8 0.5; 0.8 1.0 0.8; 0.5 0.8 1.0]\njulia> DIST = MultivariateNormal(μ, Σ)","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"Next, we define three CUSUM charts with allowance constants of 0.25, 0.5, and 1, respectively. Additionally, we define a MEWMC control chart with a smoothing constant of 0.2.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> p = length(μ)\njulia> STATS = (MCUSUM(k = 0.25, p = p), MCUSUM(k = 0.5, p = p),\n                MCUSUM(k = 1.0, p = p), MEWMC(λ = 0.2, p = p))","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"To account for the mean and covariance of the distribution, the four control charts are applied to the standardized observations, $   \\bm{Z}_t = \\Sigma_0^{-1 / 2}\\bm{X}_t. $","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"We use the type LocationScaleStatistic to standardize observations in location-scale families.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> Σ_sqm1 = inv(sqrt(Σ))\njulia> EST_STATS = Tuple(LocationScaleStatistic(s, μ, Σ_sqm1) for s in STATS)","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"Control charts will signal an alarm whenever their values cross their respective upper control limits textUCL_j.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> LIMS = Tuple(OneSidedFixedLimit(1.0, true) for _ in 1:4)","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"To find appropriate control limits, we set the nominal median run length to 200.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> NM = QRL(200, 0.5)","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"We generate Phase II observations from the IC process distribution.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> PH2 = Phase2Distribution(DIST)","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"Then, we create the ControlChart object and find the control limits.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> CH = ControlChart(EST_STATS, LIMS, NM, PH2)\njulia> h = bootstrapCL!(CH)\njulia> print(h)\n(h = [14.568353665174286, 8.627690357206408, 4.677555568948659,\n    2.360499495019121], iter = 8, status = \"Convergence\")","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"We then load the Phase II data (available at this Zenodo link) and plot the results.","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"julia> data = CSV.read(\"example77.csv\", DataFrame)\njulia> xnew = Matrix(data)[:, 1:3]\njulia> proc = apply_chart(CH, xnew)\njulia> plt = plot_series(proc, dpi = 300, label = \"\", xlab = L\"t\",\n                          ylab = L\"C_t\", subtitles = [\"MCUSUM k = 0.25\", \"MCUSUM k = 0.5\",\n                          \"MCUSUM k = 1\", \"MEWMC λ = 0.2\"])","category":"page"},{"location":"monitoring_mean_covariance.html","page":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","title":"Jointly Monitoring the Mean and Covariance Using a Multi-Chart Scheme","text":"(Image: )","category":"page"},{"location":"theory.html#Statistical-Process-Monitoring","page":"Theory","title":"Statistical Process Monitoring","text":"","category":"section"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Statistical Process Monitoring (SPM) involves using various tools to assess process stability. Here's an overview of the terminology, types of control charts, and methodologies used in SPM. ","category":"page"},{"location":"theory.html#Basic-terminology","page":"Theory","title":"Basic terminology","text":"","category":"section"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Control charts are fundamental tools for assessing process stability under the SPM framework.  In the online (Phase II) setting, the process is monitored sequentially as new data is collected. The goal is to detect deviations from the in-control (IC) state as soon as possible.","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Monitoring Statistic: Sequential calculation of a statistic C_t for t = 1 2 ldots. An alarm is raised when C_t falls outside the control limits (textLCL_t textUCL_t).\nRun Length (RL): represents the number of time points required for the monitoring procedure to signal an alarm, textRL = infleft t  0 C_t  textUCL_t text or  C_t  textLCL_t right.\nControl Limits: Selected to constrain some IC properties of the chart's RL to a nominal value. For Phase II control charts, a common design is textARL_textIC = mathbbE_0textRL = A_0   where A_0  1 and mathbbE_0cdot  represents the expectation assuming the process always remains IC.   Other designs use the median of the IC run length textMRL_textIC or the run length's quantiles.","category":"page"},{"location":"theory.html#Taxonomy-of-control-charts","page":"Theory","title":"Taxonomy of control charts","text":"","category":"section"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Control charts can be classified into three main categories:","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Shewhart-type: memoryless, reactive to large changes. Uses only the information about bmX_t at each time t  0 to compute the monitoring statistic, C_t = f(boldsymbolX_t).\nCUSUM-type: chart with memory, dampens the historical information with an update mechanism of the form C_t = maxleft 0 C_t-1 + f(bmX_t) right\nEWMA-type: chart with memory, the historical information is weighted using exponentially-decaying weights such as C_t = (1 - lambda)C_t-1 + lambda X_t","category":"page"},{"location":"theory.html#Nonparametric-control-charts","page":"Theory","title":"Nonparametric control charts","text":"","category":"section"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Traditional control charts rely on i.i.d. continuous quality variables following a parametric distribution. When these assumptions are violated, control charts designed under these assumptions can display poor performance. ","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Various nonparametric methods have been developed to relax the parametric assumptions:","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Rank-Based Charts: these use a rank transformation of the data.\nData Categorization: numerical data is categorized and then a log-linear model is subsequently monitored over time.","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"These methods help when parametric assumptions are infeasible but might lose effectiveness in information compared to parametric charts.","category":"page"},{"location":"theory.html#Selecting-hyperparameters","page":"Theory","title":"Selecting hyperparameters","text":"","category":"section"},{"location":"theory.html","page":"Theory","title":"Theory","text":"Choosing the appropriate values of tuning parameters bmzeta in mathcalZ subseteq mathbbR^d (e.g., smoothing constant lambda in EWMA, allowance constant k in CUSUM) is crucial.","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"The choice of tuning parameters aims to detect specific magnitudes of parameter change efficiently, typically formulated as:","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"beginaligned\n  fracpartial mathbbE_1textRLpartial bmzetaBig_bmzeta=bmzeta^* = bm0\n     textst  mathbbE_0textRL = A_0\nendaligned","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"When analitycal solutions are unavailable, numerical optimization methods like stochastic approximations or Monte-Carlo simulations are used.","category":"page"},{"location":"theory.html#Multi-chart-monitoring-schemes","page":"Theory","title":"Multi-chart monitoring schemes","text":"","category":"section"},{"location":"theory.html","page":"Theory","title":"Theory","text":"In complex monitoring scenarios, multiple control charts may be run simultaneously. These schemes are useful for monitoring multiple parameters jointly, such as the mean and variance of a distribution.","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"The control limits bmLCL_t = (textLCL_t1 ldots textLCL_tJ) and bmUCL_t = (textUCL_t1 ldots textUCL_tJ) are specific to each control chart, and are usually determined so that:","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"begincases\nmathbbE_0left min( textRL_1 textRL_2 ldots textRL_J) right = A_0\nmathbbE_0textRL_1 = mathbbE_0textRL_2 = ldots = mathbbE_0textRL_J\nendcases","category":"page"},{"location":"theory.html","page":"Theory","title":"Theory","text":"This design assumes equal importance of each control chart, but weighting schemes might be used to emphasize the relative importance of each control chart. Algorithms like stochastic approximations are commonly used to solve these designs. Furthermore, the expectation can be replaced by the median or quantiles of the RL in the above scheme.","category":"page"},{"location":"phase_2.html#Phase-2","page":"Phase 2","title":"Phase 2","text":"","category":"section"},{"location":"phase_2.html","page":"Phase 2","title":"Phase 2","text":"Modules = [StatisticalProcessMonitoring]\nPages = [\"phase2-interface.jl\", \"bootstrap.jl\"]","category":"page"},{"location":"phase_2.html#StatisticalProcessMonitoring.BlockBootstrap","page":"Phase 2","title":"StatisticalProcessMonitoring.BlockBootstrap","text":"BlockBootstrap{T} <: AbstractSampling\n\nRepresents a (circular) block bootstrap sampling method.\n\nFields\n\nblock::T: The current block of data being sampled from.\nblocksize::Int: The size of each block.\nt::Int: The current index within the block.\n\nConstructors\n\nBlockBootstrap(blocksize::Int, data::Vector{T}) where T: Constructs a BlockBootstrap object for a vector of data.\nBlockBootstrap(blocksize::Int, data::Matrix{T}) where T: Constructs a BlockBootstrap object for a matrix of data.\n\n\n\n\n\n","category":"type"},{"location":"phase_2.html#StatisticalProcessMonitoring.Bootstrap","page":"Phase 2","title":"StatisticalProcessMonitoring.Bootstrap","text":"Bootstrap <: AbstractSampling\n\nRepresents a bootstrap sampling method.\n\n\n\n\n\n","category":"type"},{"location":"phase_2.html#StatisticalProcessMonitoring.StationaryBootstrap","page":"Phase 2","title":"StatisticalProcessMonitoring.StationaryBootstrap","text":"StationaryBootstrap{T} <: AbstractSampling\n\nRepresents a stationary block bootstrap sampling method, where the block length is sampled from a Geometric random variable.\n\nFields\n\nblock::T: The current block of data being sampled from.\nblocksize::Int: The average size of each block.\nt::Int: The current index within the block.\n\nConstructors\n\nStationaryBootstrap(blocksize::Int, data::Vector{T}) where T: Constructs a StationaryBootstrap object for a vector of data.\nStationaryBootstrap(blocksize::Int, data::Matrix{T}) where T: Constructs a StationaryBootstrap object for a matrix of data.\n\n\n\n\n\n","category":"type"},{"location":"control_charts.html#Control-charts","page":"Control charts","title":"Control charts","text":"","category":"section"},{"location":"control_charts.html","page":"Control charts","title":"Control charts","text":"Modules = [StatisticalProcessMonitoring]\nPages = [\"charts-interface.jl\", \"simulate.jl\", \"retrospective.jl\"]","category":"page"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_design-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_design","text":"get_design(CH::AbstractChart)\n\nGet the designs of the control chart statistic.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_limit-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_limit","text":"get_limit(CH::AbstractChart)\n\nGet the control limit of a control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_limit_value-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_limit_value","text":"get_limit_value(CH::AbstractChart)\n\nGet the control limit value of a control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_maxrl-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_maxrl","text":"get_maxrl(CH::AbstractChart)\n\nGet the maximum run length of the control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_nominal-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_nominal","text":"get_nominal(CH::AbstractChart)\n\nGet the nominal properties of a control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_nominal_value-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_nominal_value","text":"get_nominal(CH::AbstractChart)\n\nGet the nominal value of a control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_phase2-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_phase2","text":"get_phase2(CH::AbstractChart)\n\nGet the phase 2 information of a control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_statistic-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_statistic","text":"get_statistic(CH::AbstractChart)\n\nGet the statistic of a control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_t-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_t","text":"get_t(CH::AbstractChart)\n\nGet the current time point of a control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.get_value-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.get_value","text":"get_value(CH::AbstractChart)\n\nGet the current value of the control chart statistic.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.is_IC-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.is_IC","text":"is_IC(CH::AbstractChart)\nis_OC(CH::AbstractChart)\n\nCheck whether the control chart is in control or out of control.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.is_IC_vec-Tuple{MultipleControlChart}","page":"Control charts","title":"StatisticalProcessMonitoring.is_IC_vec","text":"is_IC_vec(CH::MultipleControlChart)\nis_OC_vec(CH::MultipleControlChart)\n\nCheck whether each individual control chart that makes up a multiple control chart is in control or out of control.\n\nReturns\n\nA vector of Bool, whose length is equal to the number of individual statistics.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.new_data!-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.new_data!","text":"new_data(CH::AbstractChart)\n\nSimulate a new observation for the control chart from the phase 2 data, eventually modifying the underlying phase 2 object.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.new_data-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.new_data","text":"new_data(CH::AbstractChart)\n\nSimulate a new observation based on the control chart's Phase II object.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.set_design!-Tuple{StatisticalProcessMonitoring.AbstractChart, Any}","page":"Control charts","title":"StatisticalProcessMonitoring.set_design!","text":"get_design(CH::AbstractChart)\n\nSet the designs of the control chart statistic.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.set_limit!-Tuple{StatisticalProcessMonitoring.AbstractChart, StatisticalProcessMonitoring.AbstractLimit}","page":"Control charts","title":"StatisticalProcessMonitoring.set_limit!","text":"function set_limit!(CH::AbstractChart, limit::AbstractLimit)\nfunction set_limit!(CH::AbstractChart, h::Float64)\nfunction set_limit!(CH::MultipleControlChart, h::Vector{Float64})\nfunction set_limit!(CH::MultipleControlChart, h::Float64)\nfunction set_limit!(CH::MultipleControlChart, h::Float64, j::Int)\n\nSet the control limit of a control chart.\n\nReturns\n\nThe new control limit.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.set_nominal!-Union{Tuple{C}, Tuple{N}, Tuple{C, N}} where {N<:StatisticalProcessMonitoring.NominalProperties, C<:StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.set_nominal!","text":"set_nominal!(CH::AbstractChart, nominal::NominalProperties)\n\nSet the nominal properties of a control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.set_phase2!-Union{Tuple{C}, Tuple{PH2}, Tuple{C, PH2}} where {PH2<:StatisticalProcessMonitoring.AbstractPhase2, C<:StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.set_phase2!","text":"set_phase2!(CH::AbstractChart, phase2::AbstractPhase2)\n\nSet the Phase 2 information of a control chart to simulate run lenghts.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.set_statistic!-Union{Tuple{C}, Tuple{STAT}, Tuple{C, STAT}} where {STAT<:StatisticalProcessMonitoring.AbstractStatistic, C<:StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.set_statistic!","text":"function set_statistic!(CH::AbstractChart, statistic::AbstractStatistic)\n\nSet the statistic of a control chart.\n\nReturns\n\nThe new value of the statistic.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.set_t!-Union{Tuple{C}, Tuple{C, Int64}} where C<:StatisticalProcessMonitoring.AbstractChart","page":"Control charts","title":"StatisticalProcessMonitoring.set_t!","text":"function set_t!(CH::AbstractChart, t)\n\nSet the current time value of a control chart.\n\nReturns\n\nThe new time value of the control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.set_value!-Union{Tuple{C}, Tuple{C, Any}} where C<:StatisticalProcessMonitoring.AbstractChart","page":"Control charts","title":"StatisticalProcessMonitoring.set_value!","text":"function set_value!(CH::AbstractChart, value)\n\nSet the value of the statistic of a control chart.\n\nReturns\n\nThe new value of the control chart's statistic.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.shallow_copy_sim-Tuple{ControlChart}","page":"Control charts","title":"StatisticalProcessMonitoring.shallow_copy_sim","text":"shallow_copy_sim(CH::ControlChart)\n\nCreate a shallow copy of a control chart, so that only the statistic and the control limit are copied. This is done to prevent copying eventual Phase 2 data multiple times and thus reduce computational effort when optimizing the control limit and the chart tuning parameters.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.update_chart!-Tuple{StatisticalProcessMonitoring.AbstractChart, Any}","page":"Control charts","title":"StatisticalProcessMonitoring.update_chart!","text":"update_chart!(CH::AbstractChart, x)\n\nUpdate the control chart inplace using a new observation x.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.update_chart-Tuple{StatisticalProcessMonitoring.AbstractChart, Any}","page":"Control charts","title":"StatisticalProcessMonitoring.update_chart","text":"update_chart(CH::AbstractChart, x)\n\nUpdate the control chart without modifying it using a new observation x.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.update_limit!-Union{Tuple{StatisticalProcessMonitoring.AbstractChart{S, L, N, P1}}, Tuple{P1}, Tuple{N}, Tuple{L}, Tuple{S}} where {S, L<:StatisticalProcessMonitoring.DynamicLimit, N, P1}","page":"Control charts","title":"StatisticalProcessMonitoring.update_limit!","text":"update_limit!(CH::AbstractChart, x)\n\nUpdate the dynamic control limit of a control chart inplace.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.run_path_sim-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.run_path_sim","text":"run_path_sim(CH::AbstractChart; maxiter)\nrun_path_sim(CH::MultipleControlChart; maxiter)\n\nSimulates a run length path for the control chart CH by sampling new data from its Phase II object.\n\nInputs\n\nCH::AbstractChart - A control chart.\nmaxiter::Real - The maximum value of the run length. Defaults to min(maxrl(CH), 10*get_nominal_value(CH))\n\nReturns\n\nA vector containing the simulated values of the control chart.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.run_sim-Tuple{StatisticalProcessMonitoring.AbstractChart, StatisticalProcessMonitoring.AbstractPhase2}","page":"Control charts","title":"StatisticalProcessMonitoring.run_sim","text":"run_sim(CH::AbstractChart, DGP::AbstractPhase2)\n\nSimulates a run length for the control chart CH by sampling new data from the provided data-generating process DGP.\n\nInputs\n\nCH - A control chart.\nDGP - An AbstractPhase2 object.\n\nReturns\n\nAn Int representing the simulated run length.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.run_sim-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.run_sim","text":"run_sim(CH::AbstractChart)\n\nSimulates a run length for the control chart CH by sampling new data from its Phase II object.\n\nInputs\n\nCH - A control chart.\n\nReturns\n\nAn Int representing the simulated run length.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.run_sim_oc-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.run_sim_oc","text":"run_sim_oc(CH::AbstractChart; shift = 0.0)\n\nSimulates a run length under location shift for the control chart CH by sampling new data from its Phase II object.\n\nInputs\n\nCH::AbstractChart:  A control chart.\nshift::Float64 - The magnitude of location shift.\n\nReturns\n\nAn Int representing the simulated run length.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.run_sim_sa-Tuple{StatisticalProcessMonitoring.AbstractChart}","page":"Control charts","title":"StatisticalProcessMonitoring.run_sim_sa","text":"run_sim_sa(CH::AbstractChart, maxiter::Real, delta::Real)\n\nSimulates a run length for the control chart CH by sampling new data from the Phase II object, to be used by the stochastic approximation algorithm implemented in the saCL! function.\n\nInputs\n\nCH - A control chart.\nmaxiter - The maximum value of the run length.\ndelta - A value controlling how much the control limit must be shifted for the gain estimation during the first stage.\n\nReturns\n\nA NamedTuple containing the simulated run length, rl, the simulated run length with control limit shifted by delta, rlPlus, and the simulated run length with control limit shifted by -delta, rlMinus.\n\n\n\n\n\n","category":"method"},{"location":"control_charts.html#StatisticalProcessMonitoring.apply_chart!-Tuple{StatisticalProcessMonitoring.AbstractChart, AbstractVector}","page":"Control charts","title":"StatisticalProcessMonitoring.apply_chart!","text":"apply_chart(CH::AbstractChart, x::AbstractVecOrMat)\napply_chart!(CH::AbstractChart, x::AbstractVector)\napply_chart!(CH::AbstractChart, x::AbstractMatrix)\n\nApply a control chart to a data vector or data matrix x.\n\n\n\n\n\n","category":"method"},{"location":"monitoring_autoregressive.html#Residual-Based-Monitoring-of-Autocorrelated-Data","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"","category":"section"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"In this section, we demonstrate how the ResidualStatistic and AbstractPhase2 interfaces can be extended to accommodate custom data types. Specifically, we focus on monitoring the residuals of an autoregressive textAR(1) model, $   y_t = \\phi y_{t-1} + \\varepsilon_{t}, \\quad \\varepsilon_{t} \\sim N(0,1), $ using an EWMA control chart.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"First, the required packages are imported,","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"using StatisticalProcessMonitoring, Distributions, Random, NLopt, Plots, Parameters, LaTeXStrings","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"We then define a specialization of the ResidualStatistic type, which will be used to apply the control chart to the textAR(1) residuals.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> import StatisticalProcessMonitoring.residual!,\n          StatisticalProcessMonitoring.new_data!\njulia> mutable struct AR1Statistic{S} <: ResidualStatistic\n           stat::S\n           phi::Float64\n           ym1::Float64\n       end\n\njulia> function residual!(x, S::AR1Statistic)\n           yhat = x - S.phi * S.ym1   \n           S.ym1 = x\n           return yhat\n       end","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"To sample observations from an textAR(1) process, we define a new type called Phase2AR1.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> @with_kw mutable struct Phase2AR1 <: \n          StatisticalProcessMonitoring.AbstractPhase2\n          phi::Float64\n          y::Float64 = 0.0\n          init::Bool = false\n       end","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"The initial observation y_0 required to sample y_1 is initialized using the stationary distribution N(0 1  (1 + phi^2 )).","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> function new_data!(PH2::Phase2AR1)\n           if !PH2.init\n               PH2.y = randn() / sqrt(1 - PH2.phi^2)\n               PH2.init = true\n           end\n           yhat = PH2.phi * PH2.y + randn()\n           PH2.y = yhat\n           return yhat\n       end","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"We consider an textAR(1) model with phi = 05.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> seed = 4398354798\njulia> Random.seed!(seed)\njulia> phi = 0.5\njulia> PH2 = Phase2AR1(phi = phi)","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"We define an EWMA control chart applied to the residuals of the textAR(1) model using the AR1Statistic object.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> STAT = AR1Statistic(EWMA(λ = 0.1), phi, 0.0)","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"We use a two-sided control limit for the control chart.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> LIM = TwoSidedFixedLimit(1.0)","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"We set the ARLIC to 500 and create the ControlChart object.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> NOM = ARL(500)\njulia> CH = ControlChart(STAT, LIM, NOM, PH2)","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"The smoothing constant of the EWMA control chart is optimized against an anticipated persistent mean shift of delta = 2.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> delta = 2.0\njulia> rlsim_oc = x -> run_sim_oc(x, shift = delta)\njulia> settings = OptSettings(verbose = false, minpar = [0.001],\n                               maxpar = [0.99])\njulia> opt = optimize_design!(CH, rlsim_oc, settings, optimizer = :LN_BOBYQA)\njulia> print(opt)\n1-element Vector{Float64}:\n 0.13830568163003895","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"We consider 100 Phase II observations from the textAR(1) process with phi = 05.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> n = 100\njulia> tau = 50\njulia> DGP = Phase2AR1(phi = phi)\njulia> y = [new_data!(DGP) for _ in 1:n]\njulia> y[(tau+1):n] .+= delta","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"The control chart is then applied to the data and the results are plotted.","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"julia> proc = apply_chart(CH, y)\njulia> plt = plot_series(proc, dpi = 300, label = \"\", xlab = L\"t\",\n                         ylab = L\"C_t\")\njulia> vline!(plt, [tau], label = \"tau\", linestyle = :dot, colour = \"black\")","category":"page"},{"location":"monitoring_autoregressive.html","page":"Residual-Based Monitoring of Autocorrelated Data","title":"Residual-Based Monitoring of Autocorrelated Data","text":"(Image: )","category":"page"},{"location":"bibliography.html","page":"-","title":"-","text":"","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"CurrentModule = StatisticalProcessMonitoring","category":"page"},{"location":"index.html#StatisticalProcessMonitoring.jl","page":"Introduction","title":"StatisticalProcessMonitoring.jl","text":"","category":"section"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"StatisticalProcessMonitoring.jl  is a Julia package for testing the stability of sequential data streams using statistical process monitoring (SPM) techniques. The package provides a flexible framework for implementing control charts, monitoring statistics, and control limit calibration methods. The package is designed to be extensible, allowing users to define custom control charts and monitoring statistics.","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"For an extensive review of SPM and control charts, a recommended resource is the book Introduction to Statistical Process Control.","category":"page"},{"location":"index.html#Installation","page":"Introduction","title":"Installation","text":"","category":"section"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"StatisticalProcessMonitoring.jl requires Julia version 1.8 or above. To install StatisticalProcessMonitoring.jl, press the ] key inside the Julia REPL to access the interactive package manager model and run the following command","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"pkg> add StatisticalProcessMonitoring","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"Otherwise, in the standard REPL run the following command","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"julia> using Pkg\njulia> Pkg.add(\"StatisticalProcessMonitoring\")","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"Once installed, the package can be loaded by running the following command","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"julia> using StatisticalProcessMonitoring","category":"page"},{"location":"index.html#Features-overview","page":"Introduction","title":"Features overview","text":"","category":"section"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"The package focuses on Monte-Carlo-based calibration of control limits and hyperparameter optimization for control charts.\nThe package implements a general control chart interface which can be easily extended to accommodate user-defined monitoring statistics and customized control limit behaviour.","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"Classical control charts\nUnivariate and multivariate Shewhart, EWMA, CUSUM charts, as well as their adaptive generalization\nControl charts for monitoring the variance-covariance matrix.\nControl charts based on data categorization for monitoring the process mean.\nControl charts for partially-observed data streams.\nControl charts for profile monitoring.\nMulti-chart monitoring schemes\nSupport for arbitrary combination of control charts\nJoint control limit calibration for control charts\nMetrics\nMetrics based on the Average Run Length\nMetrics based on Run Length quantiles\nControl limit calibration\nControl limit estimation based on data distributions using Distributions.jl\nControl limit estimation based on bootstrap and block bootstrap of initial data\nDynamic control limits with constant false-alarm rate via bootstrap resampling\nHyperparameter tuning\nOptimization of control chart parameters for user-defined out-of-control scenarios, using grid search and nonlinear optimizers (NLopt.jl)","category":"page"},{"location":"index.html#Overview-of-other-software-packages","page":"Introduction","title":"Overview of other software packages","text":"","category":"section"},{"location":"index.html#Traditional-control-charts-in-SPM-software","page":"Introduction","title":"Traditional control charts in SPM software","text":"","category":"section"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"Most SPM software packages primarily focus on implementing traditional control charts for analyzing univariate or multivariate data. However, these packages may lack support for advanced methodologies like multi-chart schemes and user-defined control charts, requiring practitioners to develop their routines to address these limitations.","category":"page"},{"location":"index.html#Julia-packages","page":"Introduction","title":"Julia packages","text":"","category":"section"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"Other packages implementing SPM tools in Julia are:","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"MultivariateAnomalies.jl for multivariate anomaly detection","category":"page"},{"location":"index.html#R-packages","page":"Introduction","title":"R packages","text":"","category":"section"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"Some notable SPM software packages in R include:","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"qcc for Shewhart, CUSUM, and EWMA charts\nMSQC for multivariate control charts\nspc for in-control average run length and run length quantile calculations\nqicharts and qicharts2 for run charts, Shewhart and Pareto control charts\nedcc for control charts designed using the optimal economic design framework","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"Other specialized packages offer functionalities for specific applications, such as:","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"spcadjust for adjusting control limits based on estimated parameters\nfuncharts for multivariate functional data, function-on-scalar regression and function-on-function regression\nsurveillance for change detection with a focus on public health surveillance\ncpm, strucchange, bcp, and changepoint for process monitoring based on change-point models\ndfphase1 for change detection in retrospective samples using distribution-free control charts","category":"page"},{"location":"index.html#Packages-in-other-programming-languages","page":"Introduction","title":"Packages in other programming languages","text":"","category":"section"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"Limited support for SPM methodologies exists in other programming languages:","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"PySpc in Python for classical control charts\nPre-Screen in MATLAB for various control charts","category":"page"},{"location":"index.html","page":"Introduction","title":"Introduction","text":"For a detailed review of existing SPM packages across different programming languages, including their features and functionalities, refer to the complete article.","category":"page"}]
}
