# Code

The code folder includes:
* `code.R`: replication script for the main text.
* `code_appendix.R`: replication script for the appendix materials.

To keep the runtime under an hour, `code.R` will by default only do timings for EBNM problems up to size n = 10000. To reproduce the full "timing study" (which takes around two days), run `code.R` with option "full" (e.g., run `Rscript code.R full` from the command line).

In detail, the replication scripts can be run as follows:

1. Install the necessary packages:

`install.packages(c("tidyverse", "flashier", "ashr", "EbayesThresh", "REBayes", "microbenchmark", "gt", "scales", "Rtsne", "ggrepel", "cowplot"))`

2. Install the latest version of `ebnm`:

`remotes::install_github("stephenslab/ebnm")`

3. (**Appendix only**): Install MOSEK and acquire MOSEK license (http://www.mosek.com). Then install Rmosek within R as follows:

```
install.packages("Rmosek")
Rmosek::mosek_attachbuilder("<MSKHOME>/mosek/<MSKVERSION>/tools/platform/<PLATFORM>/bin")
install.rmosek()
```

4. Run `code.R` or `code_appendix.R` from the `code/` directory. Command-line options include:
  * `out-to-file`: print output (including progress updates and session info) to file
  * `test`: changes parameters so that the code runs quicker
  * `full`: do the full timing study (with large simulations)
