prog cqr, eclass
version 10

	loc bwdef = c(mindouble)
	loc lldef = c(mindouble)
	loc uldef = c(maxdouble)

	syntax varlist [if] [in], [Quantile(string) ll(real `lldef') ul(real `uldef') reps(int 20) bwidth(real `bwdef') kernel(string)] 
	
	if "`quantile'"=="" loc quantile = "0.50"
	
	if "`kernel'"=="" 	loc kernel = "gauss"
	
	tempname b0
	
	qui {
		tobit `varlist' `if' `in', ll(`ll') ul(`ul')
		mat `b0' = e(b)
		loc m = _b[sigma:_cons]
		if `bwidth'==`bwdef' loc bwidth = 0.9*`m'/((e(N))^(1/5))
		}
	
	if (`ll'==`lldef' & `ul'==`uldef') loc title "Smoothed quantile regression"
	if (`ll'!=`lldef' | `ul'!=`uldef') loc title "Censored quantile regression"	
	
	bs, reps(`reps') title(`title'): cqr_est `varlist' `if' `in' , q(`quantile') ll(`ll') ul(`ul') bwidth(`bwidth') b0(`b0') kernel(`kernel')

	eret sca bwidth = `bwidth'

end 
