prog ldvqreg, eclass
version 10

	loc bwdef = c(mindouble)
	loc lldef = c(mindouble)
	loc uldef = c(maxdouble)

	syntax varlist [if] [in], [Quantile(string) ll(real `lldef') ul(real `uldef') reps(int 20) p1(string) pcen(string) qcen(string) BWidth(real `bwdef') PBWidth(real 0.10) KERnel(string) pbc MARGins(string) XBINary(string)] 

	if "`quantile'"=="" loc quantile = "0.50"
	
	if `bwidth'!=`bwdef' & `bwidth'<=0 {
		di as error "bandwidth must be a positive number"
		error 197
		}

	if "`kernel'"=="" 				loc kernel = "gauss"
	if "`kernel'"=="gaussian" 		loc kernel = "gauss"
	if "`kernel'"=="gaussia" 		loc kernel = "gauss"
	if "`kernel'"=="gaussi" 		loc kernel = "gauss"
	if "`kernel'"=="epanechnikov" 	loc kernel = "epane"
	if "`kernel'"=="epanechniko" 	loc kernel = "epane"
	if "`kernel'"=="epanechnik" 	loc kernel = "epane"
	if "`kernel'"=="epanechni" 		loc kernel = "epane"
	if "`kernel'"=="epanechn" 		loc kernel = "epane"
	if "`kernel'"=="epanech" 		loc kernel = "epane"
	if "`kernel'"=="epanec" 		loc kernel = "epane"
	if "`kernel'"=="biweight" 		loc kernel = "biwei"
	if "`kernel'"=="biweigh" 		loc kernel = "biwei"
	if "`kernel'"=="biweig" 		loc kernel = "biwei"
	if ("`kernel'"!="gauss" & "`kernel'"!="logit" & "`kernel'"!="epane" & "`kernel'"!="biwei") { 
		di as error "invalid kernel function"
		error 197
		}
	
	if "`margins'"=="" 	loc margins = "nothing"
	if ("`margins'"!="nothing" & "`margins'"!="ape" & "`margins'"!="peam" & "`margins'"!="both") { 
		di as error "invalid partial effect option"
		error 197
		}
	
	if "`xbinary'"=="" 	loc xbinary = "nothing"
	
	if "`pbc'"!="" & "`p1'"=="" {
		di as error "the pbc option is only available when the p1 option is invoked"
		error 197
	}
	
	if "`xbinary'"!="" & "`margins'"=="" {
		di as error "the xbinary option is only available when the margins option is invoked"
		error 197
	}

	marksample touse
	gettoken lhs rhs : varlist
	
	qui {	
		tempvar randaux
		tempname check
		gen `randaux' = rnormal()
		sqreg `randaux' `rhs' if `touse', q(`quantile')
		drop `randaux'
		loc counter=0
		foreach q in `quantile' {
			loc ++counter
			loc Q_form "`Q_form' `e(q`counter')'"
			if `counter'==1 {
				mat `check' = e(b) 
				loc eqchk = word(e(eqnames),1)
				mat `check' = `check'[1,"`eqchk':"]
				loc nmchk : colnames `check'
				loc K = wordcount("`nmchk'")
				loc newrhs ""
				forv k = 1/`K' {
					loc cvar = word("`nmchk'",`k')
					if substr("`cvar'",1,2)!="o." & "`cvar'"!="_cons" loc newrhs "`newrhs' `cvar'" 
					if substr("`cvar'",1,2)=="o." noi di as text "note: `cvar' omitted because of collinearity" _n(0)
					} 
				loc rhs = "`newrhs'"
				}
			}
		loc quantile "`Q_form'"
	}
	
	capture assert missing(`lhs') | inlist(`lhs', 0, 1)
	if _rc == 0 local binary = 1
	if _rc != 0 local binary = 0
		
	if "`p1'"!="" {
		if `binary'==0 {
			di as error "p1 is for binary data only"
			error 197
		}
		if wordcount("`quantile'")==1 {
			di as error "p1 requires estimating several quantiles"
			error 197
		}
	}

	if "`pcen'"!="" {
		if `binary'==1 {
			di as error "pcen is for censored data only"
			error 197
		}
		if wordcount("`quantile'")==1 {
			di as error "pcen requires estimating several quantiles"
			error 197
		}
	}
	
	if "`qcen'"!="" {
		if `binary'==1 {
			di as error "qcen is for censored data only"
			error 197
		}
	}

	if `binary'==1 bqr `lhs' `rhs' `if' `in' , q(`quantile') reps(`reps') bwidth(`bwidth') kernel(`kernel') margins(`margins') xbinary(`xbinary')
	if `binary'==0 cqr `lhs' `rhs' `if' `in' , q(`quantile') reps(`reps') bwidth(`bwidth') kernel(`kernel') ll(`ll') ul(`ul')
	
	if "`kernel'"=="gauss" di in green "Kernel: " in ye "Gaussian" 
	if "`kernel'"=="logit" di in green "Kernel: " in ye "Logistic" 
	if "`kernel'"=="epane" di in green "Kernel: " in ye "Epanechnikov" 
	if "`kernel'"=="biwei" di in green "Kernel: " in ye "Biweight"

	if "`margins'"!="nothing" di in green "Margins: for binary covariates is the discrete change from the base level.
	
	if "`p1'"!="" {
		loc hn = `pbwidth'
		tempname xb baux auxU
		loc equ: coleq e(b)
		loc equ0 ""
		foreach i in `equ' {
				if "`i'"!="APE" & "`i'"!="PEAM" loc equ0 "`equ0' `i'"
			}
		foreach i in `equ0' {
			if "`pbc'"=="" mat `baux' = e(b)
			if "`pbc'"!="" mat `baux' = e(b_bs)
			cap mat score `xb'_`i' = `baux', eq(`i')
			cap gen i_`xb'_`i' = (`xb'_`i'>0)
			if "`kernel'"=="gauss" cap gen k_`xb'_`i' = normal(`xb'_`i'/`hn')
			if "`kernel'"=="logit" cap gen k_`xb'_`i' = exp(`xb'_`i'/`hn')/(1+exp(`xb'_`i'/`hn'))
			if "`kernel'"=="epane" {
				qui {
					generat `auxU'_`i' = 0
					replace `auxU'_`i' = (3/4)*(1/sqrt(5))*((`xb'_`i'/`hn')-(1/15)*((`xb'_`i'/`hn')^3)+ sqrt(5)*2/3) if abs((`xb'_`i'/`hn'))<sqrt(5)
					replace `auxU'_`i' = 1  if (`xb'_`i'/`hn')>=sqrt(5)
					}
				cap gen k_`xb'_`i' = `auxU'_`i' 
				drop `auxU'_`i' 
				}
			if "`kernel'"=="biwei" {
				qui {
					generat `auxU'_`i' = 0
					replace `auxU'_`i' = (15/16)*( (1/5)*(`xb'_`i'/`hn')^5 - (2/3)*(`xb'_`i'/`hn')^3 + (`xb'_`i'/`hn') + 8/15 ) if abs((`xb'_`i'/`hn'))<1
					replace `auxU'_`i' = 1  if (`xb'_`i'/`hn')>=1
					}
				cap gen k_`xb'_`i' = `auxU'_`i'
				drop `auxU'_`i'
				}			
			drop `xb'_`i'
			}
		egen `p1'   = rmean(i_`xb'_*)
		egen `p1'_s = rmean(k_`xb'_*)
		drop *_`xb'_*
	}

	if "`pcen'"!="" {
		loc hn = `pbwidth'
		tempname xb auxU auxL
		loc equ: coleq e(b)
		foreach i in `equ' {
			cap predict `xb'_`i', eq(`i')
			cap gen i_`xb'_`i' = (`xb'_`i'>`ul') + (`xb'_`i'<`ll')
			if "`kernel'"=="gauss" cap gen k_`xb'_`i' = normal((`xb'_`i'-`ul')/`hn') + 1-normal((`xb'_`i'-`ll')/`hn')
			if "`kernel'"=="logit" cap gen k_`xb'_`i' = exp((`xb'_`i'-`ul')/`hn')/(1+exp((`xb'_`i'-`ul')/`hn')) + 1-exp((`xb'_`i'-`ll')/`hn')/(1+exp((`xb'_`i'-`ll')/`hn'))
			if "`kernel'"=="epane" {
				qui {
					generat `auxU'_`i' = 0
					replace `auxU'_`i' = (3/4)*(1/sqrt(5))*(((`xb'_`i'-`ul')/`hn')-(1/15)*(((`xb'_`i'-`ul')/`hn')^3)+ sqrt(5)*2/3) if abs(((`xb'_`i'-`ul')/`hn'))<sqrt(5)
					replace `auxU'_`i' = 1  if ((`xb'_`i'-`ul')/`hn')>=sqrt(5)
					generat `auxL'_`i' = 0
					replace `auxL'_`i' = (3/4)*(1/sqrt(5))*(((`xb'_`i'-`ll')/`hn')-(1/15)*(((`xb'_`i'-`ll')/`hn')^3)+ sqrt(5)*2/3) if abs(((`xb'_`i'-`ll')/`hn'))<sqrt(5)
					replace `auxL'_`i' = 1  if ((`xb'_`i'-`ll')/`hn')>=sqrt(5)
					replace `auxL'_`i' = 1 - `auxL'_`i'	
				}
				cap gen k_`xb'_`i' = `auxU'_`i' + `auxL'_`i'
				drop `auxU'_`i' `auxL'_`i'
				}
			if "`kernel'"=="biwei" {
				qui {
					generat `auxU'_`i' = 0
					replace `auxU'_`i' = (15/16)*( (1/5)*((`xb'_`i'-`ul')/`hn')^5 - (2/3)*((`xb'_`i'-`ul')/`hn')^3 + ((`xb'_`i'-`ul')/`hn') + 8/15 ) if abs(((`xb'_`i'-`ul')/`hn'))<1
					replace `auxU'_`i' = 1  if ((`xb'_`i'-`ul')/`hn')>=1
					generat `auxL'_`i' = 0
					replace `auxL'_`i' = (15/16)*( (1/5)*((`xb'_`i'-`ll')/`hn')^5 - (2/3)*((`xb'_`i'-`ll')/`hn')^3 + ((`xb'_`i'-`ll')/`hn') + 8/15 ) if abs(((`xb'_`i'-`ll')/`hn'))<1
					replace `auxL'_`i' = 1  if ((`xb'_`i'-`ll')/`hn')>=1
					replace `auxL'_`i' = 1 - `auxL'_`i'	
				}
				cap gen k_`xb'_`i' = `auxU'_`i' + `auxL'_`i'
				drop `auxU'_`i' `auxL'_`i'
				}			
			drop `xb'_`i'
			}
		egen `pcen'   = rmean(i_`xb'_*)
		egen `pcen'_s = rmean(k_`xb'_*)
		drop *_`xb'_*
	}
	
	if "`qcen'"!="" {
		tempname xb
		loc equ: coleq e(b)
		foreach i in `equ' {
			cap predict `xb'_`i', eq(`i')
			cap generat `qcen'_`i' =  min(max(`xb'_`i',`ll'),`ul')
			drop `xb'_`i'
			}
	}
	

	
	tempname b V esample 
	if `binary'==1 tempname b_bs
	
	mat `b' = e(b) 
	mat `V' = e(V) 

	if `binary'==1 mat `b_bs' = e(b_bs)

	loc depvar = e(depvar)
	loc N = e(N)
	loc reps = e(N_reps)
	loc bwidth = e(bwidth)
	loc title = e(title)

	gen `esample' = e(sample)
	
	ereturn post `b' `V', depname(`depvar') obs(`N') esample(`esample')
	
	if `binary'==1 eret mat b_bs = `b_bs'
	
	eret sca reps = `reps'
	eret sca bwidth = `bwidth'
			
	eret loc cmd = "ldvqreg"
	if "`kernel'"=="gauss" eret loc kernel = "Gaussian" 
	if "`kernel'"=="logit" eret loc kernel = "Logistic" 
	if "`kernel'"=="epane" eret loc kernel = "Epanechnikov" 
	if "`kernel'"=="biwei" eret loc kernel = "Biweight"
	eret loc vcetype = "Bootstrap"
	eret loc title = "`title'"

end

