{smcl}
{* *! version 1  24sep2021}{...}

{title:Title}
{p2colset 5 16 19 2}{...}
{p2col:}Quantile Regression under Limited Dependent Variable
{p2colreset}{...}

{marker syntax}{...}
{title:Syntax}
{p 8 15 2}
{cmd:ldvqreg} {it:depvar} [{it:indepvars}] 
[if] [in]
[{cmd:,} {it:options}]

{marker menu}{...}
{title:Menu}

{phang}
{bf:Statistics > Nonparametric analysis > Quantile regression}


{marker description}{...}
{title:Description}

{pstd}
{opt ldvqreg} implements estimation and inference procedures for quantile regression models for the cases of censored or binary dependent variable. In the case of censorship in the dependent variable the command implements the regression
proposed by Powell (1986). For a binary outcome, the command implements the regression proposed by Mansky (1975, 1985). 
In both cases it uses a smoothed version of the objective function following the strategy proposed by Horowitz (1992), Kordas (2006) and de Castro et al. (2019).

{marker option}{...}
{title:Options}

{synoptset 19 tabbed}{...}
{synopthdr:ldvqreg_options}
{synoptline}
{syntab:General}
{synopt:{opt q:uantile(#)}} 
estimates # quantiles; default is quantile(50).
{p_end}
{synopt:{opt r:eps(#)}} 
performs # bootstrap replications; default is reps(20).
{p_end}

{syntab:Censoring}
{synopt:{opt ll(real)}} 
left-censoring limit.
{p_end}
{synopt:{opt ul(real)}} 
right-censoring limit.
{p_end}
{synopt:{opt qcen(newvar)}} 
stores predicted censored quantiles in {it:newvar_q#}.
{p_end}
{synopt:{opt pcen(newvar)}}
stores censorship probability in {it:newvar} and {it:newvar_s} (smoothed).
{p_end}

{syntab:Binary data}
{synopt:{opt p1(newvar)}}
stores probability of {it:depvar} = 1 in {it:newvar} and {it:newvar_s} (smoothed).
{p_end}
{synopt:{opt pbc}}
indicates that the predicted probability in p1({it:newvar}) should be computed with the bias-corrected coefficients.
{p_end}
{synopt:{opt marg:ins(type)}}
indicates that the partial effects indicated in {it:type} should be displayed. The options for {it:type} are: {it:{opt ape}} (Average Partial Effect), {it:{opt peam}} (Partial Effect at Means) or {it:{opt both}} (display APE and PEAM).
{p_end}
{synopt:{opt xbin:ary(varlist)}}
indicates that the covariates listed in {it:varlist} are binary. This is necessary to correctly compute the partial effects requested in the option margins({it:type}).
{p_end}

{syntab:Smoothing}
{synopt:{opt bw:idth(real)}} 
specifies the bandwidth to smooth the target function.
{p_end}
{synopt:{opt ker:nel(string)}} 
specify kernel function; the options are: {it:{opt gauss:ian}} (the default), {it:{opt logit}}, {it:{opt epane:chnikov}} or {it:{opt biwei:ght}}.
{p_end}
{synopt:{opt pbw:idth(real)}} 
specifies the bandwidth to smooth the predicted probabilities.
{p_end}


{synoptline}
{p2colreset}{...}
{p 4 6 2}

{pstd}
If ll(#) and ul(#) are not specified and the dependent variable is a dummy variable (which is automatically checked), then the command runs a binary quantile regression. If ll(#) and ul(#) are not specified but the dependent variable is not a dummy, then the command runs a smoothed quantile regression model.

{marker examples}{...}

{title:Examples}

{synoptline}
{pstd}Setup {p_end}
{phang2}{cmd:. sysuse auto}{p_end}
{phang2}{cmd:. generate wgt=weight/100}{p_end}

{pstd}Censored from above {p_end}
{phang2}{cmd:. ldvqreg mpg wgt, ul(24)}{p_end}

{pstd}Estimates 0.25, 0.50, and 0.75 quantiles simultaneously {p_end}
{phang2}{cmd:. ldvqreg mpg wgt, ul(24) q(25 50 75)}{p_end}

{pstd}Two-limit of censoring, performing 100 bootstrap replications {p_end}
{phang2}{cmd:. ldvqreg mpg wgt, ll(17) ul(24) q(20 50 80) reps(100)}{p_end}

{synoptline}
{pstd}Setup {p_end}
{phang2}{cmd:. sysuse auto}{p_end}

{pstd}Binary quantile regression (default) {p_end}
{phang2}{cmd:. ldvqreg foreign weight mpg}{p_end}

{pstd}Estimates 0.25, 0.50, and 0.75 quantiles simultaneously {p_end}
{phang2}{cmd:. ldvqreg foreign weight mpg, q(25 50 75)}{p_end}

{pstd}Same as above, but predicts probability of foreign=1 {p_end}
{phang2}{cmd:. ldvqreg foreign weight mpg, q(25 50 75) p1(myprob)}{p_end}

{synoptline}



{marker results}{...}
{title:Stored results}

{pstd}
{cmd:ldvqreg} stores the following in {cmd:e()}:

{synoptset 15 tabbed}{...}
{p2col 5 15 19 2: Scalars}{p_end}
{synopt:{cmd:e(N)}}number of observations.{p_end}
{synopt:{cmd:e(reps)}}number of replications.{p_end}
{synopt:{cmd:e(bwidth)}}bandwidth.{p_end}

{p2col 5 15 19 2: Macros}{p_end}
{synopt:{cmd:e(title)}}Censored or Binary regression model.{p_end}
{synopt:{cmd:e(vcetype)}}title used to label Std. Err.{p_end}
{synopt:{cmd:e(kernel)}}name of kernel.{p_end}
{synopt:{cmd:e(properties)}}b V.{p_end}
{synopt:{cmd:e(depvar)}}name of dependent variable.{p_end}

{p2col 5 15 19 2: Matrices}{p_end}
{synopt:{cmd:e(b)}}coefficient vector.{p_end}
{synopt:{cmd:e(V)}}bootstrap variance matrix.{p_end}
{synopt:{cmd:e(b_bs)}}bias-corrected coefficient vector (only for binary model).{p_end}

{p2col 5 15 19 2: Functions}{p_end}
{synopt:{cmd:e(sample)}}marks estimation sample.{p_end}

{p2colreset}{...}

{marker Authors}{...}
{title:Authors}

{pstd}Javier Alejo{p_end}
{pstd}IECON-UdelaR{p_end}
{pstd}Montevideo, Uruguay{p_end}
{pstd}javier.alejo@fcea.edu.uy{p_end}

{pstd}Gabriel Montes-Rojas{p_end}
{pstd}CONICET-IIEP-UBA{p_end}
{pstd}Buenos Aires, Argentina{p_end}
{pstd}gabriel.montes@fce.uba.ar{p_end}

{marker references}{...}
{title:References}

{marker DBD1990}{...}

{phang}
de Castro, L., A. Galvao, D. Kaplan, and X. Liu (2019): "Smoothed GMM for quantile models", Journal of Econometrics, 213, 121-144. {p_end}

{phang}
Horowitz, J. (1992): "A smoothed maximum score estimator for the binary response model", Econometrica, 60, 505{531. {p_end}

{phang}
Manski, C. (1975): "Maximum score estimation of the stochastic utility model of choice", Journal of Econometrics, 3(3), 205-228. {p_end}

{phang}
Manski, C. (1985): "Semiparametric analysis of discrete response: Asymptotic properties of the maximum score estimator", Journal of Econometrics, 27(3), 313-333. {p_end}

{phang}
Kordas, G. (2006): "Smoothed binary regression quantiles", Journal of Applied Econometrics, 21(3), 387-407. {p_end}

{phang}
Powell, J. L. (1986): "Censored regression quantiles", Journal of Econometrics, 32, 143-155. {p_end}

{title:Also see}

{p 7 14 2}Help: {it:{help sqreg:sqreg}}, {it:{help tobit:tobit}}, {it:{help probit:probit}}, {it:{help logit:logit}}

