prog bqr, eclass
version 10

	
	loc bwdef = c(mindouble)
	
	syntax varlist [if] [in], [Quantile(string) reps(int 20) bwidth(real `bwdef') KERnel(string) MARGins(string) XBINary(string)] 
	
	if "`quantile'"=="" loc quantile = "0.50"

	if "`kernel'"=="" 	loc kernel = "gauss"
	
	if "`margins'"==""  loc margins = "nothing"

	if "`xbinary'"==""  loc xbinary = "nothing"
	
	tempname norma b0 
	
	qui {
		probit `varlist' `if' `in'
		mat `norma' = e(b)*e(b)'
		mat `b0' = e(b)/sqrt(`norma'[1,1])
		loc m = 1
		if `bwidth'==`bwdef' loc bwidth = 0.9*`m'/((e(N))^(1/5))
		}
	
	bs, reps(`reps') title(Binary quantile regression) notable nohead: bqr_est `varlist' `if' `in' , q(`quantile') bwidth(`bwidth') b0(`b0') kernel(`kernel') margins(`margins') xbinary(`xbinary') 
	estat bootstrap
	
	eret sca bwidth = `bwidth'

end 
