prog bqr_est, eclass
version 10

	syntax varlist [if] [in], Quantile(string) bwidth(real) b0(string) kernel(string) margins(string) xbinary(string)
	
	if "`xbinary'"=="nothing" loc xbinary "-99"
	
	loc hn = `bwidth'
	
	marksample touse
	gettoken lhs rhs : varlist
	tempvar raux
	
	gen `raux' = rnormal() if `lhs'!=.
	sqreg `raux' `rhs' `if' `in', q(`quantile') reps(2)
	drop `raux'
	loc equ: coleq e(b)
	loc equ0: coleq e(b)
	
	tempname idbin
	loc r = 0
	foreach v in `rhs' {
		loc ++r
		loc check = 0
		foreach w in `xbinary' {
			loc check = `check' + ("`v'"=="`w'")
			}
		if `r'==1 mat `idbin' = `check' 
		if `r'!=1 mat `idbin' = `idbin'\\`check'
		}

	local cta = 1
	foreach q in `quantile' {
		bqr_est_p `varlist' `if' `in', q(`q') bwidth(`bwidth') b0(`b0') kernel(`kernel')
		mat bm = e(b)
		loc K = colsof(bm)
		if `cta'==1 mat BM = bm
		if `cta'!=1 mat BM = BM,bm
		mat drop bm	
		local cta = `cta' + 1
		}
	
	if "`margins'"=="ape" | "`margins'"=="both" {
		tempname xvar
		local nv = 0
		foreach v in `rhs' {
			loc ++nv
			gen `xvar'_`nv' = `v'
		}
		
		tempname vecaux xb
		loc R = `K'-1 
		forvalues r = 1/`R' {		
			loc j = 0
			foreach q in `quantile' {
				loc ++j
				loc k0 = `K'*(`j'-1)+1
				loc k1 = `K'*(`j'-1)+`K'
				mat `vecaux' = BM[1,`k0'..`k1']
				gen `xb'_`j' = `vecaux'[1,`K']
				loc k1 = `k1'-1
				forvalues c = 1/`R' {
					replace `xb'_`j' = `xb'_`j' + `xvar'_`c'*`vecaux'[1,`c']
					}			

				if `idbin'[`r',1]==0 {
					if "`kernel'"=="gauss" gen dk_`xb'_`j' = (1/`hn')*normalden(`xb'_`j'/`hn')*`vecaux'[1,`r']	
					if "`kernel'"=="logit" gen dk_`xb'_`j' = (1/`hn')*exp(-`xb'_`j'/`hn')/((1+exp(-`xb'_`j'/`hn'))^2)*`vecaux'[1,`r']	
					if "`kernel'"=="epane" gen dk_`xb'_`j' = (1/`hn')*(3/4)*(1-(`xb'_`j'/`hn')^2)*(abs(`xb'_`j'/`hn')<sqrt(5))*`vecaux'[1,`r']
					if "`kernel'"=="biwei" gen dk_`xb'_`j' = (1/`hn')*(15/16)*((1-(`xb'_`j'/`hn')^2)^2)*(abs(`xb'_`j'/`hn')<1)*`vecaux'[1,`r']
					}

				if `idbin'[`r',1]==1 {
					gen `xb'_`j'_0 = `xb'_`j' - `xvar'_`r'*`vecaux'[1,`r']
					gen `xb'_`j'_1 = `xb'_`j'_0 + `vecaux'[1,`r']
					if "`kernel'"=="gauss" {
						gen k0_`xb'_`j' = normal(`xb'_`j'_0/`hn')					
						gen k1_`xb'_`j' = normal(`xb'_`j'_1/`hn')					
						}
					if "`kernel'"=="logit" {
						gen k0_`xb'_`j' = exp(`xb'_`j'_0/`hn')/(1+exp(`xb'_`j'_0/`hn'))					
						gen k1_`xb'_`j' = exp(`xb'_`j'_1/`hn')/(1+exp(`xb'_`j'_1/`hn'))					
						}
					if "`kernel'"=="epane" {
						generat k0_`xb'_`j' = 0
						replace k0_`xb'_`j' = (3/4)*(1/sqrt(5))*((`xb'_`j'_0/`hn')-(1/15)*((`xb'_`j'_0/`hn')^3)+ sqrt(5)*2/3) if abs((`xb'_`j'_0/`hn'))<sqrt(5)
						replace k0_`xb'_`j' = 1  if (`xb'_`j'_0/`hn')>=sqrt(5)
						generat k1_`xb'_`j' = 0
						replace k1_`xb'_`j' = (3/4)*(1/sqrt(5))*((`xb'_`j'_1/`hn')-(1/15)*((`xb'_`j'_1/`hn')^3)+ sqrt(5)*2/3) if abs((`xb'_`j'_1/`hn'))<sqrt(5)
						replace k1_`xb'_`j' = 1  if (`xb'_`j'_1/`hn')>=sqrt(5)					
						}
					if "`kernel'"=="biwei" {
						generat k0_`xb'_`j' = 0
						replace k0_`xb'_`j' = (15/16)*( (1/5)*(`xb'_`j'_0/`hn')^5 - (2/3)*(`xb'_`j'_0/`hn')^3 + (`xb'_`j'_0/`hn') + 8/15 ) if abs((`xb'_`j'_0/`hn'))<1
						replace k0_`xb'_`j' = 1  if (`xb'_`j'_0/`hn')>=1
						generat k1_`xb'_`j' = 0
						replace k1_`xb'_`j' = (15/16)*( (1/5)*(`xb'_`j'_1/`hn')^5 - (2/3)*(`xb'_`j'_1/`hn')^3 + (`xb'_`j'_1/`hn') + 8/15 ) if abs((`xb'_`j'_1/`hn'))<1
						replace k1_`xb'_`j' = 1  if (`xb'_`j'_1/`hn')>=1					
						}
					gen dk_`xb'_`j'	= k1_`xb'_`j' - k0_`xb'_`j'
					drop `xb'_`j'_0 `xb'_`j'_1 k1_`xb'_`j' k0_`xb'_`j'
					}

				drop `xb'_`j'
				}
			
			tempname dk_s
			egen `dk_s' = rmean(dk_`xb'_*)
			drop dk_`xb'_*

			sum `dk_s' `if' `in'
			if `r'==1 mat dp = r(mean)
			if `r'!=1 mat dp = dp,r(mean)	
			drop `dk_s'
			
			}

		
		mat colname dp = `rhs'
		mat BM = BM, dp
		loc eqape ""
		foreach v in `rhs' {
			loc eqape "`eqape' APE"
		}	
		loc equ "`equ' `eqape'"	
	}

	if "`margins'"=="peam" | "`margins'"=="both" {

		tempname xvar
		local nv = 0
		foreach v in `rhs' {
			loc ++nv
			summ `v' `if' `in'
			gen `xvar'_`nv' = r(mean)
		}
		
		tempname vecaux xb
		loc R = `K'-1 
		forvalues r = 1/`R' {		
			loc j = 0
			foreach q in `quantile' {
				loc ++j
				loc k0 = `K'*(`j'-1)+1
				loc k1 = `K'*(`j'-1)+`K'
				mat `vecaux' = BM[1,`k0'..`k1']
				gen `xb'_`j' = `vecaux'[1,`K']
				loc k1 = `k1'-1
				forvalues c = 1/`R' {
					replace `xb'_`j' = `xb'_`j' + `xvar'_`c'*`vecaux'[1,`c']
					}			

				if `idbin'[`r',1]==0 {
					if "`kernel'"=="gauss" gen dk_`xb'_`j' = (1/`hn')*normalden(`xb'_`j'/`hn')*`vecaux'[1,`r']	
					if "`kernel'"=="logit" gen dk_`xb'_`j' = (1/`hn')*exp(-`xb'_`j'/`hn')/((1+exp(-`xb'_`j'/`hn'))^2)*`vecaux'[1,`r']	
					if "`kernel'"=="epane" gen dk_`xb'_`j' = (1/`hn')*(3/4)*(1 - (`xb'_`j'/`hn')^2)*(abs(`xb'_`j'/`hn')<sqrt(5))*`vecaux'[1,`r']
					if "`kernel'"=="biwei" gen dk_`xb'_`j' = (1/`hn')*(15/16)*((1-(`xb'_`j'/`hn')^2)^2)*(abs(`xb'_`j'/`hn')<1)*`vecaux'[1,`r']
					}

				if `idbin'[`r',1]==1 {
					gen `xb'_`j'_0 = `xb'_`j' - `xvar'_`r'*`vecaux'[1,`r']
					gen `xb'_`j'_1 = `xb'_`j'_0 + `vecaux'[1,`r']
					if "`kernel'"=="gauss" {
						gen k0_`xb'_`j' = normal(`xb'_`j'_0/`hn')					
						gen k1_`xb'_`j' = normal(`xb'_`j'_1/`hn')					
						}
					if "`kernel'"=="logit" {
						gen k0_`xb'_`j' = exp(`xb'_`j'_0/`hn')/(1+exp(`xb'_`j'_0/`hn'))					
						gen k1_`xb'_`j' = exp(`xb'_`j'_1/`hn')/(1+exp(`xb'_`j'_1/`hn'))					
						}
					if "`kernel'"=="epane" {
						generat k0_`xb'_`j' = 0
						replace k0_`xb'_`j' = (3/4)*(1/sqrt(5))*((`xb'_`j'_0/`hn')-(1/15)*((`xb'_`j'_0/`hn')^3)+ sqrt(5)*2/3) if abs((`xb'_`j'_0/`hn'))<sqrt(5)
						replace k0_`xb'_`j' = 1  if (`xb'_`j'_0/`hn')>=sqrt(5)
						generat k1_`xb'_`j' = 0
						replace k1_`xb'_`j' = (3/4)*(1/sqrt(5))*((`xb'_`j'_1/`hn')-(1/15)*((`xb'_`j'_1/`hn')^3)+ sqrt(5)*2/3) if abs((`xb'_`j'_1/`hn'))<sqrt(5)
						replace k1_`xb'_`j' = 1  if (`xb'_`j'_1/`hn')>=sqrt(5)					
						}
					if "`kernel'"=="biwei" {
						generat k0_`xb'_`j' = 0
						replace k0_`xb'_`j' = (15/16)*( (1/5)*(`xb'_`j'_0/`hn')^5 - (2/3)*(`xb'_`j'_0/`hn')^3 + (`xb'_`j'_0/`hn') + 8/15 ) if abs((`xb'_`j'_0/`hn'))<1
						replace k0_`xb'_`j' = 1  if (`xb'_`j'_0/`hn')>=1
						generat k1_`xb'_`j' = 0
						replace k1_`xb'_`j' = (15/16)*( (1/5)*(`xb'_`j'_1/`hn')^5 - (2/3)*(`xb'_`j'_1/`hn')^3 + (`xb'_`j'_1/`hn') + 8/15 ) if abs((`xb'_`j'_1/`hn'))<1
						replace k1_`xb'_`j' = 1  if (`xb'_`j'_1/`hn')>=1					
						}
					gen dk_`xb'_`j'	= k1_`xb'_`j' - k0_`xb'_`j'
					drop `xb'_`j'_0 `xb'_`j'_1 k1_`xb'_`j' k0_`xb'_`j'
					}

				drop `xb'_`j'
				}
			
			tempname dk_s
			egen `dk_s' = rmean(dk_`xb'_*)
			drop dk_`xb'_*

			sum `dk_s' `if' `in'
			if `r'==1 mat dp = r(mean)
			if `r'!=1 mat dp = dp,r(mean)	
			drop `dk_s'
			
			}

		
		mat colname dp = `rhs'
		mat BM = BM, dp
		loc eqpeam ""
		foreach v in `rhs' {
			loc eqpeam "`eqpeam' PEAM"
		}
		loc equ "`equ' `eqpeam'"
	}
	
	

	if "`margins'"=="nothing" {
		mat BM = BM
	}

	matrix coleq BM = `equ'
	eret post BM, e(`touse') depname(`lhs')
	eret di
	
end 
