clear all
set seed 1
set more off

cap log close
log using log-employment-app.log, replace

use labordatauy, clear
describe

** BINARY MODEL

* Probit model
probit work age educ children married couplewrk head
mat b_probit = e(b)
svmat b_probit
sca norm = 0
foreach b of varlist b_probit* {
		sca norm = norm + `b'[1]^2
	}
sca norm = sqrt(norm)
outreg2 using "bin-qreg.xls", stnum(replace coef=coef/norm, replace se=se/norm) replace

* Smoothed Binary QR
timer on 1
ldvqreg work age educ children married couplewrk head, reps(100) q(20 50 80)
outreg2 using "bin-qreg.xls", append
timer off 1

test [q20=q50=q80]
test (0.5*_b[q20:age]+0.5*_b[q80:age]=_b[q50:age]) ///
	 (0.5*_b[q20:edu]+0.5*_b[q80:edu]=_b[q50:edu]) ///	
	 (0.5*_b[q20:mar]+0.5*_b[q80:mar]=_b[q50:mar]) ///	
	 (0.5*_b[q20:chi]+0.5*_b[q80:chi]=_b[q50:chi]) ///	
	 (0.5*_b[q20:cou]+0.5*_b[q80:cou]=_b[q50:cou]) ///	
	 (0.5*_b[q20:hea]+0.5*_b[q80:hea]=_b[q50:hea]) ///	
	 (0.5*_b[q20:_co]+0.5*_b[q80:_co]=_b[q50:_co])	

** PARTIAL EFFECTS ON PROBABILITY

* Probit (APE)
probit work c.age c.educ c.children i.married i.couplewrk i.head
predict pr_probit, pr
margins, dydx(_all) post
outreg2 using "bin-margins.xls", replace 

* Probit (PEAM)
probit work c.age c.educ c.children i.married i.couplewrk i.head
margins, dydx(_all) at((mean)age educ children married=0 couplewrk=0 head=0) post
outreg2 using "bin-margins.xls", append

* Smoothed Binary QR
timer on 2
ldvqreg work age educ children married couplewrk head, reps(100) q(10 20 30 40 50 60 70 80 90) margins(both) xbin(married children head) p1(pr_bqr)
outreg2 using "bin-margins.xls", append
timer off 2

timer list
	 
log close

* Figure of conditional probability
keep if educ==12
keep if married==0
keep if children==0
keep if couplewrk==0
keep if head==0

sort age
twoway (line pr_* age, lw(thick thick thick)), legend(row(1) order(1 "Probit" 2 "BQR (Naive)" 3 "BQR (Smoothed)") pos(6)) ytitle("Probability of working")
graph export Figure-work.png, replace width(1000)

shell del *.txt
