clear all
set more off

** CENSORED VARIABLE
***********************************
cap log close
log using "log-censoring-qr.log", replace

* A simple example
set seed 321
set obs 1000

gen x = runiform()
gen y = -1/3 + x + x*rnormal()/3
gen y_c = max(y,0)

regress y x
predict xb_mco

tobit y_c x, ll(0)
predict xb_tob

ldvqreg y_c x, ll(0)
predict xb_cqr

twoway (scatter y_c x, mc(gs10)) (scatter y x, ms(x) mc(black)) ///
	   (line xb_mco xb_tob xb_cqr x, lc(red blue green)), ///
	   legend(row(1) order(1 2 3 "OLS (unachievable)" 4 "Tobit" 5 "q50 (CQR)") ///
	   pos(6))

graph export Figure1.png, replace width(1000)

* A more general example 
drop _all
set seed 321
set obs 4000

gen heter = (_n>_N/2)

gen x = runiform()
gen y = .
replace y = x + rnormal()/3 	 	if heter==0
replace y = x + (1+x)*rnormal()/3   if heter==1
gen y_c = min(max(y,0),1)

* Without the options ll() or ul() it assumes that there is no censoring
sqreg y x if heter==0 , q(20 50 80) reps(100)
estimates store sqr0
test [q20=q50=q80]: x
ldvqreg y x if heter==0 , q(20 50 80) reps(100)
estimates store ldv0
test [q20=q50=q80]: x

sqreg y x if heter==1 , q(20 50 80) reps(100)
estimates store sqr1
test [q20=q50=q80]: x
ldvqreg y x if heter==1 , q(20 50 80) reps(100)
estimates store ldv1
test [q20=q50=q80]: x

* Censorship points
timer on 1
ldvqreg y_c x if heter==0 , q(20 50 80) reps(100) ll(0) ul(1)
timer off 1
estimates store ldv0c
test [q20=q50=q80]: x

timer on 2
ldvqreg y_c x if heter==1 , q(20 50 80) reps(100) ll(0) ul(1)
timer off 2
estimates store ldv1c
test [q20=q50=q80]: x

estimates table sqr0 sqr1 ldv0 ldv1 ldv0c ldv1c 
drop _est*

timer list

* Kernel and bandwidth changes
ldvqreg y_c x , q(20 50 80) reps(10) ll(0) ul(1) 
estimates store cqr_k1
ldvqreg y_c x , q(20 50 80) reps(10) ll(0) ul(1) ker(logit)
estimates store cqr_k2 
ldvqreg y_c x , q(20 50 80) reps(10) ll(0) ul(1) ker(epane) 
estimates store cqr_k3
ldvqreg y_c x , q(20 50 80) reps(10) ll(0) ul(1) ker(biwei) 
estimates store cqr_k4
estimates table cqr_k*

ldvqreg y_c x , q(20 50 80) reps(10) ll(0) ul(1) 
estimates store cqr_h0
loc h1 = e(bwidth)/2
loc h2 = e(bwidth)*2
ldvqreg y_c x , q(20 50 80) reps(10) ll(0) ul(1) bw(`h1')
estimates store cqr_h1
ldvqreg y_c x , q(20 50 80) reps(10) ll(0) ul(1) bw(`h2')
estimates store cqr_h2

estimates table cqr_h*
drop _est*

* Compare with sqreg under censorship.
sqreg y_c x, reps(5) q(20 50 80)
estimates store sqr_c
ldvqreg y_c x, reps(5) q(20 50 80) ll(0) ul(1)
estimates store ldv_c

estimates table sqr_c ldv_c
drop _est*


* Prediction
ldvqreg y_c x , reps(2) q(10 20 30 40 50 60 70 80 90) ///
ll(0) ul(1) qcen(myqcen) pcen(mypcen)
summarize

log close

* PLOTS

gen samgph = 1 if runiform()>0.50

* Misspecification under censoring
sqreg y_c x, reps(5) q(20 50 80)
predict sqr20, eq(q20)
predict sqr50, eq(q50)
predict sqr80, eq(q80)

ldvqreg y_c x, reps(5)  q(20 50 80) ll(0) ul(1)
predict ldv20, eq(q20)
predict ldv50, eq(q50)
predict ldv80, eq(q80)

twoway (scatter y_c x, mc(gs10)) (scatter y x, ms(x) mc(black)) ///
	   (line sqr* x, lc(red blue green)) ///
	   if samgph==1, legend(row(1) order(1 2 3 "q20" 4 "q50" 5 "q80") pos(6)) ///
	   title(sqreg)
graph save plotA, replace

twoway (scatter y_c x, mc(gs10)) (scatter y x, ms(x) mc(black)) ///
	   (line ldv* x, lc(red blue green)) ///
	   if samgph==1, legend(row(1) order(1 2 3 "q20" 4 "q50" 5 "q80") pos(6)) ///
	   title(ldvqreg)
graph save plotB, replace

graph combine plotA.gph plotB.gph, ysize(12) xsize(20)
graph export Figure2.png, replace width(1000)

* Prediction
sort x

drop myqcen_q20 myqcen_q40 myqcen_q60 myqcen_q80

twoway (scatter y_c x, mc(gs10)) ///
       (line myqcen* x, lw(thick thick thick thick thick)) ///
	   if samgph==1,legend(row(1) order(2 "q10" 3 "q30" 4 "q50" 5 "q70" 6 "q90") pos(6)) 
graph save plotA, replace

twoway (line mypcen* x, lw(thick thick)) ///
		if samgph==1, legend(order(1 "Naive" 2 "Smoothed") pos(6)) ///
		ytitle("Censorship probability")
graph save plotB, replace

graph combine plotA.gph plotB.gph, ysize(10) xsize(20)
graph export Figure3.png, replace width(1000)

erase plotA.gph
erase plotB.gph

** BINARY VARIABLE
***********************************
cap log close
log using "log-binary-qr.log", replace

drop _all
set seed 321
set obs 2000

gen x = runiform()*10
gen y = -2.5 + x + x*(rchi2(1)-1)/sqrt(2)

gen y_b = (y>0)
ta y_b

* Comparing coefficients with | b | = 1
quietly probit y_b x
nlcom (_b[x]/sqrt(_b[x]^2+_b[_cons]^2)) ///
	  (_b[_cons]/sqrt(_b[x]^2+_b[_cons]^2)), post 
estimates store mle_n

quietly bsqreg y x
nlcom (_b[x]/sqrt(_b[x]^2+_b[_cons]^2)) ///
	  (_b[_cons]/sqrt(_b[x]^2+_b[_cons]^2)), post 
estimates store qr_n

quietly ldvqreg y_b x
nlcom (_b[x]) (_b[_cons]), post 
estimates store ldv_b

estimates table mle_n qr_n ldv_b 
drop _est*


* Compare with sqreg
quietly bsqreg y_b x, q(20)
nlcom (_b[x]/sqrt(_b[x]^2+_b[_cons]^2)) ///
      (_b[_cons]/sqrt(_b[x]^2+_b[_cons]^2)), post
estimates store qr20_b
quietly ldvqreg y_b x, q(20)
nlcom (_b[x]) (_b[_cons]), post 
estimates store ldv20_b

quietly bsqreg y_b x, q(50)
nlcom (_b[x]/sqrt(_b[x]^2+_b[_cons]^2)) ///
	  (_b[_cons]/sqrt(_b[x]^2+_b[_cons]^2)), post
estimates store qr50_b
quietly ldvqreg y_b x, q(50)
nlcom (_b[x]) (_b[_cons]), post 
estimates store ldv50_b

estimates table qr20_b qr50_b ldv20_b ldv50_b
drop _est*	 

*bsqreg y_b x, q(80)


* INFERENCE

* With unobservable data (uncensored)
timer on 3
sqreg y x , q(10 25 50 75 90) reps(300)
timer off 3

* Homogeneity
test [q10=q25=q50=q75=q90]: x

* Symmetry
test (([q10]x+[q25]x+[q75]x+[q90]x)/4-[q50]x=0) ///
	 (([q10]_cons+[q25]_cons+[q75]_cons+[q90]_cons)/4-[q50]_cons=0)

* With observable data (censored)
timer on 4
ldvqreg y_b x , q(10 25 50 75 90) reps(300)
timer off 4

* Homogeneity
test [q10=q25=q50=q75=q90]: x

* Symmetry
test (([q10]x+[q25]x+[q75]x+[q90]x)/4-[q50]x=0) ///
	 (([q10]_cons+[q25]_cons+[q75]_cons+[q90]_cons)/4-[q50]_cons=0)

timer list 3
timer list 4
	 
	 
	 
* PREDICTION
probit y_b x
predict p_pro
ldvqreg y_b x , reps(2) q(10 20 30 40 50 60 70 80 90) ll(0) ul(1) p1(p_bqr)
summarize

log close

sort x
twoway (line p_* x, lw(thick thick thick)), ///
	    legend(row(1) order(1 "Probit" 2 "BQR (Naive)" 3 "BQR (Smoothed)") ///
		pos(6)) ytitle("Pr(Y=1|X=x)")
graph export Figure4.png, replace width(1000)
