clear all
set seed 1
set more off

cap log close
log using log-wage-app.log, replace

use wichert-wilke, clear

* CENSORED MODEL

* Doubly censored dependent variable (Figure 4.(a) Wichert & Wilke, 2010)
histogram wage, xtitle(Previous daily wage (in EUROS)) ytitle(relative frequency)
graph export "Figure-wage-app.png", replace width(1000)

* Tobit Model
tobit wage age female, ll(0) ul(200)
outreg2 using "wage-app.xls", replace

* Censored QR
ldvqreg wage age female, ll(0) ul(200) reps(100) q(20 50 80)
outreg2 using "wage-app.xls", append

test [q20=q50=q80]

test (0.5*_b[q20:age]+0.5*_b[q80:age]=_b[q50:age]) ///
	 (0.5*_b[q20:female]+0.5*_b[q80:female]=_b[q50:female]) ///	
	 (0.5*_b[q20:_co]+0.5*_b[q80:_co]=_b[q50:_co])	

log close

shell del *.txt




