# Summarize, in terms of mean, median, quantiles of the metrics stored as csv files
# and generated by different algorithms.
# The summaries are (for now) grouped by data, graph and parameters.
# Averages are usually taken over different seeds.

library(dplyr, warn.conflicts = FALSE)
library(rjson)
library(argparser)

p <- arg_parser("Combining benchmarks data from differents sources.")
p <- add_argument(p, "--filename", help = "Filename")
p <- add_argument(p, "--bmark_setup", help = "Benchmark setup title")
p <- add_argument(p, "--joint_bench", help = "Joint")
p <- add_argument(p, "--config_filename", help = "Filename config file")
p <- add_argument(p, "--algorithms", help = "Algorithms", nargs = Inf)
argv <- parse_args(p)

config <- fromJSON(file = argv$config_filename)

toplot <- data.frame()

# argv$algorithms is a list of paths such as results/order_mcmc.csv.
# This loop gets the active algorithms from the filenames. It is a bit ugly.
active_algorithms <- c()
for (file in argv$algorithms) {
  active_algorithms <- c(
    active_algorithms,
    tools::file_path_sans_ext(basename(file))
  )
}

joint_df <- data.frame()
active_algorithms <- unique(active_algorithms)

benchmarksalgs <- config$benchmark_setup$evaluation$benchmarks$ids

for (algorithm in active_algorithms) {
  # This reads all object ids of one algorithm so that the
  # same could be read more than once.
  # The problem is that the curve variable is needed.
  # It is fixed by running the distinct function.
  
    # find index of the benchmark setup
    bmark_ind <- 1
    for (i in 1:length(config$benchmark_setup)) {
        if (config$benchmark_setup[[i]]$title == argv$bmark_setup) {
            bmark_ind <- i
            break
        }
    }


    fp <- file.path(
        "results/output",argv$bmark_setup,"benchmarks",
        paste(config$benchmark_setup[[bmark_ind]]$evaluation$benchmarks$filename_prefix,
        algorithm,
        ".csv",
        sep = ""
        )
        )

    ROCdf <- read.csv(fp)
    #print(ROCdf)

  unique_ids <- ROCdf %>% distinct(id)


  if (sum(is.na(ROCdf[, "true_n_edges_skel"])) == nrow(ROCdf)) {
    # Only NAs. This happens if all instatitiations of
    # the algorithm was timed out.
    next
  }

  for (params_id in unique_ids$id) {

    # Find curve param
    # Finds the varying curve automatically as the one which is an array.
    curve_param <- NULL
    for (a in config$resources$structure_learning_algorithms[[algorithm]]) {
      if (a$id == params_id) {
        curve_param <- names(a)[[2]] # Since 1 use to be id :)
        for (key in names(a)) {
          if (is.vector(a[[key]]) && key != "mcmc_seed" && key != "id") {
            if (length(a[[key]]) > 1) {
              curve_param <- key
              break
            }
          }
        }
      }
    }

    # Creating the raw file and inlcuding the curve parameter and value.
    tmpdf <- ROCdf %>% filter(id == params_id)
    tmpdf["curve_param"] <- curve_param
    tmpdf["curve_value"] <- tmpdf[curve_param]
    tmpdf <- mutate_at(tmpdf, vars(curve_value), as.factor)

    joint_df <- dplyr::bind_rows(joint_df, tmpdf)

    sumROC <- ROCdf %>%
      filter(!is.na(true_n_edges_skel)) %>%
      filter(id == params_id) %>% # Extract only the rows for the actual id
      group_by(id, adjmat, parameters, data, !!as.symbol(curve_param)) %>%
      summarise(
        SHD_pattern_mean = mean(SHD_pattern),
        TPR_pattern_mean = mean(TPR_pattern),
        TPR_pattern_median = median(TPR_pattern),
        TPR_pattern_q1 = quantile(TPR_pattern, probs = c(0.05)),
        TPR_pattern_q3 = quantile(TPR_pattern, probs = c(0.95)),
        FPR_pattern_mean = mean(FPR_pattern),
        FPR_pattern_median = median(FPR_pattern),
        FPR_pattern_q1 = quantile(FPR_pattern, probs = c(0.05)),
        FPR_pattern_q3 = quantile(FPR_pattern, probs = c(0.95)),
        FPRn_pattern_mean = mean(FPRn_pattern),
        FPRn_pattern_median = median(FPRn_pattern),
        FPRn_pattern_q1 = quantile(FPRn_pattern, probs = c(0.05)),
        FPRn_pattern_q3 = quantile(FPRn_pattern, probs = c(0.95)),
        TPR_skel_mean = mean(TP_skel / true_n_edges_skel),
        TPR_skel_median = median(TP_skel / true_n_edges_skel),
        TPR_skel_q1 = quantile(TP_skel / true_n_edges_skel, probs = c(0.05)),
        TPR_skel_q3 = quantile(TP_skel / true_n_edges_skel, probs = c(0.95)),
        FPR_skel_mean = mean(FPR_skel),
        FPR_skel_median = median(FP_skel / true_n_edges_skel),
        FPR_skel_q1 = quantile(FPR_skel, probs = c(0.05)),
        FPR_skel_q3 = quantile(FPR_skel, probs = c(0.95)),
        FNR_skel_mean = mean(FNR_skel),
        FNR_skel_median = median(FNR_skel),
        FNR_skel_q1 = quantile(FNR_skel, probs = c(0.05)),
        FNR_skel_q3 = quantile(FNR_skel, probs = c(0.95)),
        time_mean = mean(time),
        time_median = median(time),
        time_q1 = quantile(time, probs = c(0.05)),
        time_q3 = quantile(time, probs = c(0.95)),
        n_seeds = n(),
        curve_vals = mean(!!as.symbol(curve_param))
      )

    sumROC["curve_param"] <- curve_param
    toplot <- dplyr::bind_rows(toplot, sumROC)
  }
}

toplot <- toplot %>% distinct()

if (nrow(toplot) > 0) {
  write.csv(joint_df, argv$joint_bench, quote = FALSE)
  write.csv(toplot, argv$filename, quote = FALSE)
} else {
  print("Creating empty files.")
  file.create(argv$filename)
  file.create(argv$joint_bench)
}
